/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.util.List;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibFileRef;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;

public class MibImport
implements MibContext {
    private MibLoader loader;
    private Mib mib = null;
    private MibFileRef fileRef;
    private String name;
    private List<String> symbols;

    MibImport(MibLoader loader, MibFileRef fileRef, String name, List<String> symbols) {
        this.loader = loader;
        this.fileRef = fileRef;
        this.name = name;
        this.symbols = symbols;
    }

    public void initialize(MibLoaderLog log) {
        this.mib = this.loader.getMib(this.name);
        if (this.mib == null) {
            String msg = "couldn't find referenced MIB '" + this.name + "', " + "skipping import of " + this.symbols.size() + " symbols";
            log.addWarning(this.fileRef, msg);
        } else if (this.symbols != null) {
            for (String sym : this.symbols) {
                if (this.mib.getSymbol(sym) != null) continue;
                String msg = "couldn't find imported symbol '" + sym + "' in MIB '" + this.name + "'";
                log.addWarning(this.fileRef, msg);
            }
        }
    }

    protected void validateSmiVersion(MibLoaderLog log, Mib mib) {
        int importedVer;
        int expectedVer = mib.getSmiVersion();
        int n = importedVer = this.mib == null ? 0 : this.mib.getSmiVersion();
        if (this.mib != null && expectedVer != importedVer) {
            String msg = "imported " + this.name + " module is SMIv" + importedVer + ", instead of SMIv" + expectedVer;
            log.addWarning(this.fileRef, msg);
        }
    }

    boolean hasSymbols() {
        return this.symbols != null;
    }

    public String getName() {
        return this.name;
    }

    public Mib getMib() {
        return this.mib;
    }

    public List<String> getAllSymbolNames() {
        return this.symbols;
    }

    @Override
    public MibSymbol findSymbol(String name, boolean expanded) {
        if (this.mib == null) {
            return null;
        }
        if (!expanded && this.symbols != null && !this.symbols.contains(name)) {
            return null;
        }
        return this.mib.getSymbol(name);
    }

    public String toString() {
        return this.name;
    }
}

