/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

public class CharBuffer {
    private int length = 0;
    private char[] contents = null;

    public CharBuffer() {
        this(16);
    }

    public CharBuffer(int initialSize) {
        this.contents = new char[initialSize];
    }

    public CharBuffer(String str) {
        this.length = str.length();
        this.contents = str.toCharArray();
    }

    public CharBuffer(StringBuffer str) {
        this.length = str.length();
        this.contents = new char[this.length];
        str.getChars(0, this.length, this.contents, 0);
    }

    public CharBuffer append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public CharBuffer append(char c) {
        this.ensureCapacity(this.length + 1);
        this.contents[this.length++] = c;
        return this;
    }

    public CharBuffer append(char[] str) {
        return this.append(str, 0, str.length);
    }

    public CharBuffer append(char[] str, int offset, int length) {
        this.ensureCapacity(this.length + length);
        System.arraycopy(str, offset, this.contents, this.length, length);
        this.length += length;
        return this;
    }

    public CharBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public CharBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public CharBuffer append(int i) {
        return this.append(String.valueOf(i));
    }

    public CharBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public CharBuffer append(Object obj) {
        return this.append(obj.toString());
    }

    public CharBuffer append(String str) {
        this.ensureCapacity(this.length + str.length());
        str.getChars(0, str.length(), this.contents, this.length);
        this.length += str.length();
        return this;
    }

    public CharBuffer append(StringBuffer str) {
        this.ensureCapacity(this.length + str.length());
        str.getChars(0, str.length(), this.contents, this.length);
        this.length += str.length();
        return this;
    }

    public char charAt(int index) throws StringIndexOutOfBoundsException {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.contents[index];
    }

    public CharBuffer delete(int start, int end) throws StringIndexOutOfBoundsException {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.length) {
            end = this.length;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        if (end - start > 0) {
            System.arraycopy(this.contents, end, this.contents, start, this.length - end);
            this.length -= end - start;
        }
        return this;
    }

    public void ensureCapacity(int size) {
        if (this.contents.length >= size) {
            return;
        }
        if (size < 2 * this.contents.length + 2) {
            size = 2 * this.contents.length + 2;
        }
        char[] newContents = new char[size];
        System.arraycopy(this.contents, 0, newContents, 0, this.length);
        this.contents = newContents;
    }

    public int length() {
        return this.length;
    }

    public String substring(int start) throws StringIndexOutOfBoundsException {
        return this.substring(start, this.length);
    }

    public String substring(int start, int end) throws StringIndexOutOfBoundsException {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.length) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.contents, start, end - start);
    }

    public String toString() {
        return new String(this.contents, 0, this.length);
    }
}

