/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpAccess;
import net.percederberg.mibble.snmp.SnmpIndex;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.type.ElementType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.SequenceType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpObjectType
extends SnmpType {
    private MibType syntax;
    private String units;
    private SnmpAccess access;
    private SnmpStatus status;
    private String reference;
    private ArrayList<SnmpIndex> index;
    private MibValue augments;
    private MibValue defaultValue;

    public SnmpObjectType(MibType syntax, String units, SnmpAccess access, SnmpStatus status, String description, String reference, ArrayList<SnmpIndex> index, MibValue defaultValue) {
        super("OBJECT-TYPE", description);
        this.syntax = syntax;
        this.units = units;
        this.access = access;
        this.status = status;
        this.reference = reference;
        this.index = index;
        this.augments = null;
        this.defaultValue = defaultValue;
    }

    public SnmpObjectType(MibType syntax, String units, SnmpAccess access, SnmpStatus status, String description, String reference, MibValue augments, MibValue defaultValue) {
        super("OBJECT-TYPE", description);
        this.syntax = syntax;
        this.units = units;
        this.access = access;
        this.status = status;
        this.reference = reference;
        this.index = new ArrayList(0);
        this.augments = augments;
        this.defaultValue = defaultValue;
    }

    @Override
    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        if (!(symbol instanceof MibValueSymbol)) {
            throw new MibException(symbol.getFileRef(), "only values can have the " + this.getName() + " type");
        }
        this.syntax = this.syntax.initialize(symbol, log);
        this.checkType((MibValueSymbol)symbol, log, this.syntax);
        for (SnmpIndex idx : this.index) {
            idx.initialize(symbol, log);
        }
        if (this.augments != null) {
            this.augments = this.augments.initialize(log, this.syntax);
        }
        if (this.defaultValue != null) {
            this.defaultValue = this.defaultValue.initialize(log, this.syntax);
        }
        return this;
    }

    private void checkType(MibValueSymbol symbol, MibLoaderLog log, MibType type) throws MibException {
        if (type instanceof SequenceOfType) {
            SequenceOfType sequence = (SequenceOfType)type;
            this.checkType(symbol, log, sequence.getElementType());
        } else if (type instanceof SequenceType) {
            int i = 1;
            for (ElementType elem : ((SequenceType)type).getAllElements()) {
                this.checkElement(symbol, log, elem, i++);
            }
        }
    }

    private void checkElement(MibValueSymbol symbol, MibLoaderLog log, ElementType element, int pos) throws MibException {
        Mib mib;
        MibSymbol elementSymbol;
        String name = String.valueOf(pos);
        if (element.getName() != null) {
            name = pos + " '" + element.getName() + "'";
        }
        if ((elementSymbol = (mib = symbol.getMib()).getSymbol(element.getName())) == null) {
            log.addWarning(symbol.getFileRef(), "sequence element " + name + " is undefined " + "in MIB, a default symbol will be created");
            name = element.getName();
            if (name == null) {
                name = symbol.getName() + "." + pos;
            }
            SnmpObjectType type = new SnmpObjectType(element.getType(), null, SnmpAccess.READ_ONLY, SnmpStatus.CURRENT, "AUTOMATICALLY CREATED SYMBOL", null, new ArrayList<SnmpIndex>(0), null);
            ObjectIdentifierValue value = (ObjectIdentifierValue)symbol.getValue();
            value = new ObjectIdentifierValue(symbol.getFileRef(), value, element.getName(), pos);
            elementSymbol = new MibValueSymbol(symbol.getFileRef(), mib, name, type, value);
            elementSymbol.initialize(log);
        } else if (elementSymbol instanceof MibTypeSymbol) {
            throw new MibException(symbol.getFileRef(), "sequence element " + name + " does not refer to a value, but " + "to a type");
        }
    }

    @Override
    public boolean isCompatible(MibValue value) {
        return value instanceof ObjectIdentifierValue;
    }

    public MibType getSyntax() {
        return this.syntax;
    }

    public String getUnits() {
        return this.units;
    }

    public SnmpAccess getAccess() {
        return this.access;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getReference() {
        return this.reference;
    }

    public ArrayList<SnmpIndex> getIndex() {
        return this.index;
    }

    public MibValue getAugments() {
        return this.augments;
    }

    public MibValue getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append(" (");
        buffer.append("\n  Syntax: ");
        buffer.append(this.syntax);
        if (this.units != null) {
            buffer.append("\n  Units: ");
            buffer.append(this.units);
        }
        buffer.append("\n  Access: ");
        buffer.append(this.access);
        buffer.append("\n  Status: ");
        buffer.append(this.status);
        if (this.getUnformattedDescription() != null) {
            buffer.append("\n  Description: ");
            buffer.append(this.getDescription("               "));
        }
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        if (this.index.size() > 0) {
            buffer.append("\n  Index: ");
            buffer.append(this.index);
        }
        if (this.augments != null) {
            buffer.append("\n  Augments: ");
            buffer.append(this.augments);
        }
        if (this.defaultValue != null) {
            buffer.append("\n  Default Value: ");
            buffer.append(this.defaultValue);
        }
        buffer.append("\n)");
        return buffer.toString();
    }
}

