/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpCompliance;

public class SnmpModule {
    private String module;
    private ArrayList<MibValue> groups;
    private ArrayList<SnmpCompliance> compliances;
    private String comment = null;

    public SnmpModule(String module, ArrayList<MibValue> groups, ArrayList<SnmpCompliance> compliances) {
        this.module = module;
        this.groups = groups;
        this.compliances = compliances;
    }

    void initialize(MibLoaderLog log) throws MibException {
        for (int i = 0; i < this.groups.size(); ++i) {
            this.groups.set(i, this.groups.get(i).initialize(log, null));
        }
        for (SnmpCompliance comp : this.compliances) {
            comp.initialize(log);
        }
    }

    public String getModule() {
        return this.module;
    }

    public ArrayList<MibValue> getGroups() {
        return this.groups;
    }

    public ArrayList<SnmpCompliance> getCompliances() {
        return this.compliances;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        if (this.module != null || !"THIS MODULE".equalsIgnoreCase(comment)) {
            this.comment = comment;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.module != null) {
            buffer.append(this.module);
        }
        if (this.groups.size() > 0) {
            buffer.append("\n    Mandatory Groups: ");
            buffer.append(this.groups);
        }
        for (SnmpCompliance comp : this.compliances) {
            buffer.append("\n    Module: ");
            buffer.append(comp);
        }
        return buffer.toString();
    }
}

