/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import uk.co.westhawk.snmp.pdu.BlockPdu;
import uk.co.westhawk.snmp.stack.varbind;

public class SnmpResponse {
    public int errorStatus;
    public String errorStatusString;
    public int errorIndex;
    public ArrayList<String> oids = new ArrayList();
    private HashMap<String, String> values = new HashMap();

    public SnmpResponse(BlockPdu pdu, varbind[] variables) {
        this.errorStatus = pdu.getErrorStatus();
        this.errorStatusString = pdu.getErrorStatusString();
        this.errorIndex = pdu.getErrorIndex();
        if (variables != null) {
            for (varbind bind : variables) {
                this.oids.add(bind.getOid().toString());
                this.values.put(bind.getOid().toString(), bind.getValue().toString());
            }
        }
    }

    public int getCount() {
        return this.oids.size();
    }

    public String getOid(int index) {
        if (index < 0 || index >= this.oids.size()) {
            return null;
        }
        return this.oids.get(index).toString();
    }

    public Iterator<String> getOids() {
        return this.oids.iterator();
    }

    public String getValue(int index) {
        return this.getValue(this.getOid(index));
    }

    public String getValue(String oid) {
        return this.values.get(oid);
    }

    public String getOidsAndValues() {
        StringBuilder buffer = new StringBuilder();
        for (String oid : this.oids) {
            buffer.append(oid);
            buffer.append(": ");
            buffer.append(this.getValue(oid));
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getOidsAndValues());
        buffer.append("Error status: ");
        buffer.append(this.errorStatus);
        buffer.append("\n");
        buffer.append("Error index: ");
        buffer.append(this.errorIndex);
        buffer.append("\n");
        buffer.append("Error status message: ");
        buffer.append(this.errorStatusString);
        buffer.append("\n");
        return buffer.toString();
    }
}

