/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.percederberg.mibble.browser.BrowserFrame;

class MacUIHelper
implements InvocationHandler {
    public static final boolean IS_MAC_OS = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private BrowserFrame frame;

    public MacUIHelper(BrowserFrame frame) {
        this.frame = frame;
        try {
            Class<?> appCls = Class.forName("com.apple.eawt.Application");
            Class<?> lstnCls = Class.forName("com.apple.eawt.ApplicationListener");
            Method method = appCls.getMethod("getApplication", new Class[0]);
            Object app = method.invoke(null, new Object[0]);
            method = appCls.getMethod("addAboutMenuItem", new Class[0]);
            method.invoke(app, new Object[0]);
            method = appCls.getMethod("removePreferencesMenuItem", new Class[0]);
            method.invoke(app, new Object[0]);
            method = appCls.getMethod("addApplicationListener", lstnCls);
            ClassLoader cl = this.getClass().getClassLoader();
            Object proxy = Proxy.newProxyInstance(cl, new Class[]{lstnCls}, (InvocationHandler)this);
            method.invoke(app, proxy);
        }
        catch (Exception e) {
            System.err.println("Failed to initialize Mac OS Application:");
            e.printStackTrace();
        }
    }

    @Override
    public Object invoke(Object p, Method m, Object[] args) {
        if (m.getName().equals("handleAbout")) {
            this.setHandled(args[0]);
            this.frame.showAbout();
        } else if (m.getName().equals("handleQuit")) {
            this.setHandled(args[0]);
            this.frame.quit();
        }
        return null;
    }

    private void setHandled(Object event) {
        try {
            Class<?> cls = event.getClass();
            Method method = cls.getMethod("setHandled", Boolean.TYPE);
            method.invoke(event, Boolean.TRUE);
        }
        catch (Exception e) {
            System.err.println("Failed to invoke ApplicationEvent.setHandled(true):");
            e.printStackTrace();
        }
    }
}

