/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.asn1;

import java.io.Reader;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.TokenPattern;
import net.percederberg.grammatica.parser.Tokenizer;

public class Asn1Tokenizer
extends Tokenizer {
    public Asn1Tokenizer(Reader input) throws ParserCreationException {
        super(input, false);
        this.createPatterns();
    }

    private void createPatterns() throws ParserCreationException {
        TokenPattern pattern = new TokenPattern(1001, "DOT", 1, ".");
        this.addPattern(pattern);
        pattern = new TokenPattern(1002, "DOUBLE_DOT", 1, "..");
        this.addPattern(pattern);
        pattern = new TokenPattern(1003, "TRIPLE_DOT", 1, "...");
        this.addPattern(pattern);
        pattern = new TokenPattern(1004, "COMMA", 1, ",");
        this.addPattern(pattern);
        pattern = new TokenPattern(1005, "SEMI_COLON", 1, ";");
        this.addPattern(pattern);
        pattern = new TokenPattern(1006, "LEFT_PAREN", 1, "(");
        this.addPattern(pattern);
        pattern = new TokenPattern(1007, "RIGHT_PAREN", 1, ")");
        this.addPattern(pattern);
        pattern = new TokenPattern(1008, "LEFT_BRACE", 1, "{");
        this.addPattern(pattern);
        pattern = new TokenPattern(1009, "RIGHT_BRACE", 1, "}");
        this.addPattern(pattern);
        pattern = new TokenPattern(1010, "LEFT_BRACKET", 1, "[");
        this.addPattern(pattern);
        pattern = new TokenPattern(1011, "RIGHT_BRACKET", 1, "]");
        this.addPattern(pattern);
        pattern = new TokenPattern(1012, "MINUS", 1, "-");
        this.addPattern(pattern);
        pattern = new TokenPattern(1013, "LESS_THAN", 1, "<");
        this.addPattern(pattern);
        pattern = new TokenPattern(1014, "VERTICAL_BAR", 1, "|");
        this.addPattern(pattern);
        pattern = new TokenPattern(1015, "DEFINITION", 1, "::=");
        this.addPattern(pattern);
        pattern = new TokenPattern(1016, "DEFINITIONS", 1, "DEFINITIONS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1017, "EXPLICIT", 1, "EXPLICIT");
        this.addPattern(pattern);
        pattern = new TokenPattern(1018, "IMPLICIT", 1, "IMPLICIT");
        this.addPattern(pattern);
        pattern = new TokenPattern(1019, "TAGS", 1, "TAGS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1020, "BEGIN", 1, "BEGIN");
        this.addPattern(pattern);
        pattern = new TokenPattern(1021, "END", 1, "END");
        this.addPattern(pattern);
        pattern = new TokenPattern(1022, "EXPORTS", 1, "EXPORTS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1023, "IMPORTS", 1, "IMPORTS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1024, "FROM", 1, "FROM");
        this.addPattern(pattern);
        pattern = new TokenPattern(1025, "MACRO", 1, "MACRO");
        this.addPattern(pattern);
        pattern = new TokenPattern(1026, "INTEGER", 1, "INTEGER");
        this.addPattern(pattern);
        pattern = new TokenPattern(1027, "REAL", 1, "REAL");
        this.addPattern(pattern);
        pattern = new TokenPattern(1028, "BOOLEAN", 1, "BOOLEAN");
        this.addPattern(pattern);
        pattern = new TokenPattern(1029, "NULL", 1, "NULL");
        this.addPattern(pattern);
        pattern = new TokenPattern(1030, "BIT", 1, "BIT");
        this.addPattern(pattern);
        pattern = new TokenPattern(1031, "OCTET", 1, "OCTET");
        this.addPattern(pattern);
        pattern = new TokenPattern(1032, "STRING", 1, "STRING");
        this.addPattern(pattern);
        pattern = new TokenPattern(1033, "ENUMERATED", 1, "ENUMERATED");
        this.addPattern(pattern);
        pattern = new TokenPattern(1034, "SEQUENCE", 1, "SEQUENCE");
        this.addPattern(pattern);
        pattern = new TokenPattern(1035, "SET", 1, "SET");
        this.addPattern(pattern);
        pattern = new TokenPattern(1036, "OF", 1, "OF");
        this.addPattern(pattern);
        pattern = new TokenPattern(1037, "CHOICE", 1, "CHOICE");
        this.addPattern(pattern);
        pattern = new TokenPattern(1038, "UNIVERSAL", 1, "UNIVERSAL");
        this.addPattern(pattern);
        pattern = new TokenPattern(1039, "APPLICATION", 1, "APPLICATION");
        this.addPattern(pattern);
        pattern = new TokenPattern(1040, "PRIVATE", 1, "PRIVATE");
        this.addPattern(pattern);
        pattern = new TokenPattern(1041, "ANY", 1, "ANY");
        this.addPattern(pattern);
        pattern = new TokenPattern(1042, "DEFINED", 1, "DEFINED");
        this.addPattern(pattern);
        pattern = new TokenPattern(1043, "BY", 1, "BY");
        this.addPattern(pattern);
        pattern = new TokenPattern(1044, "OBJECT", 1, "OBJECT");
        this.addPattern(pattern);
        pattern = new TokenPattern(1045, "IDENTIFIER", 1, "IDENTIFIER");
        this.addPattern(pattern);
        pattern = new TokenPattern(1046, "INCLUDES", 1, "INCLUDES");
        this.addPattern(pattern);
        pattern = new TokenPattern(1047, "MIN", 1, "MIN");
        this.addPattern(pattern);
        pattern = new TokenPattern(1048, "MAX", 1, "MAX");
        this.addPattern(pattern);
        pattern = new TokenPattern(1049, "SIZE", 1, "SIZE");
        this.addPattern(pattern);
        pattern = new TokenPattern(1050, "WITH", 1, "WITH");
        this.addPattern(pattern);
        pattern = new TokenPattern(1051, "COMPONENT", 1, "COMPONENT");
        this.addPattern(pattern);
        pattern = new TokenPattern(1052, "COMPONENTS", 1, "COMPONENTS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1053, "PRESENT", 1, "PRESENT");
        this.addPattern(pattern);
        pattern = new TokenPattern(1054, "ABSENT", 1, "ABSENT");
        this.addPattern(pattern);
        pattern = new TokenPattern(1055, "OPTIONAL", 1, "OPTIONAL");
        this.addPattern(pattern);
        pattern = new TokenPattern(1056, "DEFAULT", 1, "DEFAULT");
        this.addPattern(pattern);
        pattern = new TokenPattern(1057, "TRUE", 1, "TRUE");
        this.addPattern(pattern);
        pattern = new TokenPattern(1058, "FALSE", 1, "FALSE");
        this.addPattern(pattern);
        pattern = new TokenPattern(1059, "PLUS_INFINITY", 1, "PLUS-INFINITY");
        this.addPattern(pattern);
        pattern = new TokenPattern(1060, "MINUS_INFINITY", 1, "MINUS-INFINITY");
        this.addPattern(pattern);
        pattern = new TokenPattern(1061, "MODULE_IDENTITY", 1, "MODULE-IDENTITY");
        this.addPattern(pattern);
        pattern = new TokenPattern(1062, "OBJECT_IDENTITY", 1, "OBJECT-IDENTITY");
        this.addPattern(pattern);
        pattern = new TokenPattern(1063, "OBJECT_TYPE", 1, "OBJECT-TYPE");
        this.addPattern(pattern);
        pattern = new TokenPattern(1064, "NOTIFICATION_TYPE", 1, "NOTIFICATION-TYPE");
        this.addPattern(pattern);
        pattern = new TokenPattern(1065, "TRAP_TYPE", 1, "TRAP-TYPE");
        this.addPattern(pattern);
        pattern = new TokenPattern(1066, "TEXTUAL_CONVENTION", 1, "TEXTUAL-CONVENTION");
        this.addPattern(pattern);
        pattern = new TokenPattern(1067, "OBJECT_GROUP", 1, "OBJECT-GROUP");
        this.addPattern(pattern);
        pattern = new TokenPattern(1068, "NOTIFICATION_GROUP", 1, "NOTIFICATION-GROUP");
        this.addPattern(pattern);
        pattern = new TokenPattern(1069, "MODULE_COMPLIANCE", 1, "MODULE-COMPLIANCE");
        this.addPattern(pattern);
        pattern = new TokenPattern(1070, "AGENT_CAPABILITIES", 1, "AGENT-CAPABILITIES");
        this.addPattern(pattern);
        pattern = new TokenPattern(1071, "LAST_UPDATED", 1, "LAST-UPDATED");
        this.addPattern(pattern);
        pattern = new TokenPattern(1072, "ORGANIZATION", 1, "ORGANIZATION");
        this.addPattern(pattern);
        pattern = new TokenPattern(1073, "CONTACT_INFO", 1, "CONTACT-INFO");
        this.addPattern(pattern);
        pattern = new TokenPattern(1074, "DESCRIPTION", 1, "DESCRIPTION");
        this.addPattern(pattern);
        pattern = new TokenPattern(1075, "REVISION", 1, "REVISION");
        this.addPattern(pattern);
        pattern = new TokenPattern(1076, "STATUS", 1, "STATUS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1077, "REFERENCE", 1, "REFERENCE");
        this.addPattern(pattern);
        pattern = new TokenPattern(1078, "SYNTAX", 1, "SYNTAX");
        this.addPattern(pattern);
        pattern = new TokenPattern(1079, "BITS", 1, "BITS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1080, "UNITS", 1, "UNITS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1081, "ACCESS", 1, "ACCESS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1082, "MAX_ACCESS", 1, "MAX-ACCESS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1083, "MIN_ACCESS", 1, "MIN-ACCESS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1084, "INDEX", 1, "INDEX");
        this.addPattern(pattern);
        pattern = new TokenPattern(1085, "AUGMENTS", 1, "AUGMENTS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1086, "IMPLIED", 1, "IMPLIED");
        this.addPattern(pattern);
        pattern = new TokenPattern(1087, "DEFVAL", 1, "DEFVAL");
        this.addPattern(pattern);
        pattern = new TokenPattern(1088, "OBJECTS", 1, "OBJECTS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1089, "ENTERPRISE", 1, "ENTERPRISE");
        this.addPattern(pattern);
        pattern = new TokenPattern(1090, "VARIABLES", 1, "VARIABLES");
        this.addPattern(pattern);
        pattern = new TokenPattern(1091, "DISPLAY_HINT", 1, "DISPLAY-HINT");
        this.addPattern(pattern);
        pattern = new TokenPattern(1092, "NOTIFICATIONS", 1, "NOTIFICATIONS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1093, "MODULE", 1, "MODULE");
        this.addPattern(pattern);
        pattern = new TokenPattern(1094, "MANDATORY_GROUPS", 1, "MANDATORY-GROUPS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1095, "GROUP", 1, "GROUP");
        this.addPattern(pattern);
        pattern = new TokenPattern(1096, "WRITE_SYNTAX", 1, "WRITE-SYNTAX");
        this.addPattern(pattern);
        pattern = new TokenPattern(1097, "PRODUCT_RELEASE", 1, "PRODUCT-RELEASE");
        this.addPattern(pattern);
        pattern = new TokenPattern(1098, "SUPPORTS", 1, "SUPPORTS");
        this.addPattern(pattern);
        pattern = new TokenPattern(1099, "VARIATION", 1, "VARIATION");
        this.addPattern(pattern);
        pattern = new TokenPattern(1100, "CREATION_REQUIRES", 1, "CREATION-REQUIRES");
        this.addPattern(pattern);
        pattern = new TokenPattern(1101, "BINARY_STRING", 2, "'[0-1]*'(B|b)");
        this.addPattern(pattern);
        pattern = new TokenPattern(1102, "HEXADECIMAL_STRING", 2, "'[0-9A-Fa-f]*'(H|h)");
        this.addPattern(pattern);
        pattern = new TokenPattern(1103, "QUOTED_STRING", 2, "\"([^\"]|\"\")*\"");
        this.addPattern(pattern);
        pattern = new TokenPattern(1104, "IDENTIFIER_STRING", 2, "[a-zA-Z][a-zA-Z0-9-_]*");
        this.addPattern(pattern);
        pattern = new TokenPattern(1105, "NUMBER_STRING", 2, "[0-9]+");
        this.addPattern(pattern);
        pattern = new TokenPattern(1106, "WHITESPACE", 2, "[ \\t\\n\\r\\f\\x0b\\x17\\x18\\x19\\x1a]+");
        pattern.setIgnore();
        this.addPattern(pattern);
        pattern = new TokenPattern(1107, "COMMENT", 2, "--([^\\n\\r-]|-[^\\n\\r-])*(--|-?[\\n\\r])");
        pattern.setIgnore();
        this.addPattern(pattern);
    }
}

