/*
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license.
 * Please see the LICENSE file for details.
 *
 * OracleSids.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.util.*;
import java.io.*;
import java.net.*;

/**
 *
 * @author  visigoth
 */
public class OracleSids extends AbstractDatabaseProbe {
    
    /** Creates a new instance of OracleSids */
    public OracleSids() {
        setName("Oracle SID Enumeration");
        setFamily("Oracle");
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        setVersion("$Id: OracleSids.java,v 1.4 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(12);

        setReport("Got SIDS:\n\n");

        setHelp("This probe enumerates Oracle SIDs");
        
        addDepends("oracle/status");

        addProvides("oracle/sids","java.lang.Vector of SID names");

    }
    
    public void probe() throws ProbeException {


        if (! kbHas("oracle/status"))
            return;

        sids = new Vector();

        setReportable(true);

        status = (String)kbGet("oracle/status");

        int index = status.indexOf(sidKey);

        while ( index != -1) {
            int offset = index + sidKey.length();
            String remain = status.substring(offset);
            String sid = remain.substring(0, remain.indexOf(')'));
            if (! sids.contains(sid)) {
                addReport(sid);
                sids.add(sid);
            }

            index = status.indexOf(sidKey, offset);
        }

        kbPut("oracle/sids",sids);
    }

    String status;
    String sidKey = "INSTANCE_NAME=";
    Vector sids;
}
