/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * OraclePasswordOptions.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;

/**
 *
 * @author  visigoth
 */
public class OraclePasswordOptions extends AbstractDatabaseProbe {
    
    /** Creates a new instance of OraclePasswordOptions */
    public OraclePasswordOptions() {
        
        setName("Oracle Password Options");
        setFamily("Oracle");
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        setVersion("$Id: OraclePasswordOptions.java,v 1.7 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(14);
        
        addDepends("oracle/connection");
        
        setReport("Oracle Password Configs: \n");
        
        setHelp("This probe attemtps to enumerate password config options. "+
        "It will only be capable of doing so if the JDBC Connection "+
        "stored in oracle/connection has sufficient privelages\n");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("oracle/connection"))
                return;
            
            con = (Connection) kbGet("oracle/connection");
            
            Statement stmt = con.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_UPDATABLE);
            res = stmt.executeQuery("SELECT PROFILE,RESOURCE_NAME,LIMIT from sys.dba_profiles WHERE RESOURCE_TYPE=\'PASSWORD\'");
            
            setReportable(true);
            
            addResultSet(res);
            
            res.beforeFirst();
            
            while (res.next()) {
                if (res.getString("RESOURCE_NAME").matches("FAILED_LOGIN_ATTEMPTS"))
                    if (res.getString("LIMIT").matches("UNLIMITED"))
                        setSeverity(getSeverity()+1);
                
                
                if (res.getString("RESOURCE_NAME").matches("PASSWORD_LIFE_TIME"))
                    if (res.getString("LIMIT").matches("UNLIMITED"))
                        setSeverity(getSeverity()+1);
                
                
                if (res.getString("RESOURCE_NAME").matches("PASSWORD_VERIFY_FUNCTION"))
                    if (res.getString("LIMIT").matches("NULL"))
                        setSeverity(getSeverity()+1);
            }
            
        } catch (SQLException se) {
            throw(new ProbeException(se.getMessage()));
        }
    }
    
    Connection con;
    ResultSet res;
}
