/*
 *
 * (c) visigoth <visigoth@securitycentric.com>
 *
 * OracleParameters.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.util.*;

/**
 *
 * @author  
 */
public class OracleParameters extends AbstractDatabaseProbe {
    
    /** Creates a new instance of OracleParameters */
    public OracleParameters() {
        
        setName("Oracle Parameters");
	setFamily("Oracle");
        setVersion("$Id: OracleParameters.java,v 1.1 2003/09/24 12:11:45 visigoth_6 Exp $");
        setProbeId(50);
        setCopyright("(c) visigoth <visigoth@securitycentric.com>");
        setSeverity(0);
        
	addProvides("oracle/Parameters","Properties object of runtime vars");
        addDepends("oracle/connection");
        
        setReport("The current Oracle Parameters:\n");
        
        setHelp("This probe enumerates all the run-time variables which are "+
		"stored in v$parameter.  Other "+
		"probes may use the information it provides for further "+
		"analysis");
    }
    
    public void probe() throws ProbeException {
        
	Properties prop = new Properties();

        try {
            
            if (! kbHas("oracle/connection"))
                return;

            con = (Connection) kbGet("oracle/connection");
            
            Statement stmt = con.createStatement();
            res = stmt.executeQuery("select name,value from v$parameter");
            
            setReportable(true);

	    addResultSet(res);

	    while (res.next()) {
		prop.setProperty(res.getString(1),res.getString(2));
	    }

        } catch (SQLException se) {
            throw(new ProbeException(se.getMessage()));
        }

	kbPut("oracle/Parameters",prop);
    }

    Connection con;
    ResultSet res;
}
