/*
 *
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 *
 * OracleJavaPermissions.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.util.*;

/**
 *
 * @author  
 */
public class OracleJavaPermissions extends AbstractDatabaseProbe {
    
    /** Creates a new instance of OracleJavaPermissions */
    public OracleJavaPermissions() {
        
        setName("Oracle JAVA Permissions");
        setFamily("Oracle");
        setVersion("$Id: OracleJavaPermissions.java,v 1.4 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(33);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        setSeverity(0);
        
        addDepends("oracle/connection");
        
        setReport("The Oracle JAVA VM has the following permissions:\n");
        
        setHelp("This probe checks the permissions on the JAVA stored procedure subsystem.");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("oracle/connection"))
                return;

            con = (Connection) kbGet("oracle/connection");
            
            Statement stmt = con.createStatement();
            res = stmt.executeQuery("select grantee,type_name,name,action from sys.dba_java_policy where kind = 'GRANT' and enabled = 'ENABLED'");
            
            setReportable(true);

            addResultSet(res);

        } catch (SQLException se) {
            throw(new ProbeException(se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
}
