/*
 * (c) visigoth <visigoth@securitycentric.com>
 *
 * MysqlComChangeUser.java
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

/**
 *
 * @author  visigoth
 */
public class MysqlComChangeUser extends AbstractVersionProbe {
    
    /** Creates a new instance of MysqlComChangeUser */
    public MysqlComChangeUser() {
        
        setName("MySQL COM_CHANGE_USER");
	setFamily("MySQL");
        setVersion("$Id: MysqlComChangeUser.java,v 1.1 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(45);
        setCopyright("(c) visigoth <visigoth@securitycentric.com>");
        
        addDepends("mysql/Version");
        
        setHelp("This probe checks for Mysql Version < 3.23.54 to enumerate CVE: CAN-2002-1375 (COM_CHANGE_USER )");

        setReport("The COM_CHANGE_USER command in MySQL 3.x before 3.23.54 allows remote attackers to execute arbitrary code via a long response. It is suspected that an attacker must have valid DB credentials to exploit.\n\nCVE: CAN-2002-1375");
        setSeverity(2);

        setKbKey("mysql/Version");
        setMatchRelease(true);
        setTestVersion("3.23.54");
    }
}
