/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * MssqlUsers.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.util.*;

/**
 *
 * @author  visigoth
 */
public class MssqlUsers extends AbstractDatabaseProbe {
    
    /** Creates a new instance of MssqlUsers */
    public MssqlUsers() {
        
        setName("Mssql Users");
        setFamily("MS SQL");
        setVersion("$Id: MssqlUsers.java,v 1.11 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(15);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mssql/connection");
        addProvides("mssql/users","Vector of strings for usernames");
        addProvides("mssql/hashes","Vector of strings for password hashes");
        
        setReport("Found Mssql Users:\n"+
                  "NAME\tHASH\n"+
                  "=================================\n");
        
        setHelp("This probe attemtps to enumerate DB users and passwords. "+
                "It will only be capable of doing so if the JDBC Connection "+
                "stored in mssql/connection has sufficient privelages\n");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("mssql/connection"))
                return;
            
            con = (Connection) kbGet("mssql/connection");
            Vector users = new Vector();
            Vector hashes = new Vector();
            
            Statement stmt = con.createStatement();
            res = stmt.executeQuery("select syslogins.name,sysxlogins.password,isntname from syslogins inner join sysxlogins on syslogins.name = sysxlogins.name");
            
            setReportable(true);
            
            while (res.next()) {
                if (res.getBoolean("isntname"))
                    continue;

                addReport(res.getString("name") + 
                          "\t" + res.getString("password"));
                users.add(res.getString("name"));
                hashes.add(res.getString("password"));
            }

            kbPut("mssql/users",users);
            kbPut("mssql/hashes",hashes);
                
        } catch (SQLException se) {
            throw(new ProbeException("Lack of Permission? " + se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
}
