/*
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

/**
 *
 * @author  visigoth
 */
public class MssqlSp3 extends AbstractVersionProbe {
    
    /** Creates a new instance of MssqlSp3 */
    public MssqlSp3() {
        
        setName("MSSQL SP3a");
        setFamily("MS SQL");
        setVersion("$Id: MssqlSp3.java,v 1.5 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(25);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mssql/Version");
        
        setHelp("This probe checks for MSSQL 2000 Service Pack 3a");

        setReport("MSSQL Service Pack 3a is not installed.\n\n"+
                  "Service pack two addresses multiple known exploitable\n"+
                  "security vulnerabilities.  Please see MS support for \n"+
                  "details:\n\n"+
                  "http://support.microsoft.com/default.aspx?scid=kb;[LN];306908");
        setSeverity(3);

        setKbKey("mssql/Version");
        setMatchRelease(true);
        setTestVersion("8.0.760.09");
    }
}
