/*
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 *
 * MssqlSlammer.java
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

/**
 *
 * @author  visigoth
 */
public class MssqlSlammer extends AbstractVersionProbe {
    
    /** Creates a new instance of MssqlSlammer */
    public MssqlSlammer() {
        
        setName("MSSQL Slammer");
        setFamily("MS SQL");
        setVersion("$Id: MssqlSlammer.java,v 1.2 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(32);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mssql/Version");
        
        setHelp("This probe checks MSSQL server for vulnerability to the Slammer exploit");

        setReport("This MSSQL server is vulnerable to the exploit which is\n"+
                  "used by the MSSQL Slammer worm!  Please see Microsoft\n"+
                  "for details:\n\n"+
                  "http://www.microsoft.com/technet/treeview/default.asp?url=/technet/security/bulletin/MS02-039.asp");
        setSeverity(3);

        setKbKey("mssql/Version");
        setMatchRelease(true);
        setTestVersion("8.0.655");
    }
}
