/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * MssqlDefaultDbs.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.util.*;

/**
 *
 * @author  visigoth
 */
public class MssqlDefaultDbs extends AbstractDatabaseProbe {
    
    /** Creates a new instance of MssqlDefaultDbs */
    public MssqlDefaultDbs() {
        
        setName("Mssql Default DBs");
        setFamily("MS SQL");
        setVersion("$Id: MssqlDefaultDbs.java,v 1.5 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(17);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mssql/dbs");
        
        setReport("The following default databases are present\n"+
                  "----------------------------------\n");

        setHelp("This probe attemtps to determine if any of the default "+
                "databases are still present\n");
    }
    
    public void probe() throws ProbeException {
        
        if (! kbHas("mssql/dbs"))
            return;

        Vector dbs = (Vector)kbGet("mssql/dbs");
        
        for (int i = 0; i < dbNames.length; i++) {
            if (dbs.contains(dbNames[i])) {
                setReportable(true);
                setSeverity(2);
                addReport(dbNames[i]);
            }
        }
    }
    String[] dbNames = {"pubs", "Northwind"};
}
