/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * MssqlAuth.java
 *
 * Created on May 5, 2003, 7:26 AM
 */

import com.securitycentric.metacoretex.*;
import com.securitycentric.metacoretex.lib.*;
import com.securitycentric.metacoretex.interfaces.*;

import java.sql.*;
import java.util.*;

/**
 *
 * @author  visigoth
 */
public class MssqlAuth extends AbstractProbe {
    
    /** Creates a new instance of OracleAuth */
    public MssqlAuth() {
        
        setName("MSSQL Authentication Tester");
        setFamily("MS SQL");
        setVersion("$Id: MssqlAuth.java,v 1.5 2003/10/02 02:20:43 visigoth_6 Exp $");
        setProbeId(2);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addProvides("mssql/connection","java.sql.Connection to the target MSSQL db");
        addDepends("tcp/ports");
        
        addOption("user","sa");
        addOption("password","");
        addOption("database","master");
        addOption("tds","4.2");
        
        setHelp("This probe attempts to connect to an available MSSQL database "+
                "using the user specified connection information.  Upon successful "+
                "connection, the probe will put the JDBC Connection object into the "+
                "KB under key mssql/connection\n\n"+
                "Options:\n"+
                "mssql/user - The username to use for connecting\n\n"+
                "mssql/password - The password to use for connecting\n\n"+
                "mssql/database - The database to use\n\n"+
                "mssql/tds - The version of the TDS protocol to use when connecting.  Use 7.0 for MSSQL 2000, and 4.2 for all else\n\n");
        
        setReport("Could NOT connect to MSSQL database");
    }
    
    /** Ok, this ones a little counterintuitive.  Return a true on
     *  a failure to connect so they report will show why all those
     *  other modules failed to connect
     */
    public void probe() throws ProbeException {
        
        if (kbHas("tcp/1433")) {
            Boolean bol = (Boolean)kbGet("tcp/1433");
            if ( ! bol.booleanValue()) {
                return;
            }
        }
        
        // Create some properties we can hand off to getConnection()
        prop = new Properties();
        prop.setProperty("user",getOption("user"));
        prop.setProperty("password",getOption("password"));
        prop.setProperty("tds",getOption("tds"));
        
        try {
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
        } catch (ClassNotFoundException ce) {
            throw(new ProbeException("FreeTDS Driver not installed?"));
        }
        
        
        try {
            con = DriverManager.getConnection("jdbc:jtds:sqlserver://" + getHost() + "/" + getOption("database"), prop);
        } catch (SQLException se) {

            if (se.getMessage().startsWith("FIXME")) {
                setReport("Username/Password Failed!");
                setReportable(true);
                return;
            }

            throw(new ProbeException(se.getMessage()));
        }
        
        kbPut("mssql/user",getOption("user"));
        kbPut("mssql/pass",getOption("password"));
        kbPut("mssql/connection",con);
    }
    
    Properties prop;
    Connection con;
}
