/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * MssqlAuditLevel.java
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;

/**
 *
 * @author  visigoth
 */
public class MssqlAuditLevel extends AbstractDatabaseProbe {
    
    /** Creates a new instance of MssqlAuditLevel */
    public MssqlAuditLevel() {
        
        setName("MSSQL Audit Level");
        setFamily("MS SQL");
        setVersion("$Id: MssqlAuditLevel.java,v 1.4 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(41);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        addDepends("mssql/connection");

        addProvides("mssql/audit","Integer value for MSSQL AuditLevel regkey");

        setHelp("This probe checks the MSSQL logon auditing configuration. "+
                "It will only be capable of doing so if the JDBC Connection "+
                "stored in mssql/connection has sufficient privelages\n");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("mssql/connection"))
                return;
            
            con = (Connection) kbGet("mssql/connection");

            PreparedStatement stmt = con.prepareStatement("exec xp_regread ?,?,?");
            stmt.setString(1,"HKEY_LOCAL_MACHINE");
            stmt.setString(2,"SOFTWARE\\Microsoft\\MSSQLServer\\MSSQLServer");
            stmt.setString(3,"AuditLevel");

            res = stmt.executeQuery();
            
            setReportable(true);
            
            while (res.next()) {
                int audit = res.getInt("Data");
                String audLvl = new String();
                switch (audit) {
                    case 0:
                        audLvl = "NONE";
                        setSeverity(3);
                        break;

                    case 1:
                        audLvl = "Success Only";
                        setSeverity(2);
                        break;

                    case 2:
                        audLvl = "Failure Only";
                        setSeverity(1);
                        break;

                    case 3:
                        audLvl = "Both Failure AND Success";
                        setSeverity(0);
                        break;
                }

                setReport("Mssql authentication currently logging on: "+audLvl);

                kbPut("mssql/audit",new Integer(audit));
            }

        } catch (SQLException se) {
            throw(new ProbeException("Lack of Permission? " + se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
}
