/*
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 *
 * Mssql7sp3.java
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

/**
 *
 * @author  USERNAME
 */
public class Mssql7sp3 extends AbstractVersionProbe {
    
    /** Creates a new instance of Mssql7sp3 */
    public Mssql7sp3() {
        
        setName("MSSQL 7 SP3");
        setFamily("MS SQL");
        setVersion("$Id: Mssql7sp3.java,v 1.2 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(39);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mssql/Version");
        
        setHelp("This probe checks MSSQL 7 for SP3");

        setReport("MSSQL 7 Service Pack 3 is not installed.\n\nService pack two addresses multiple known exploitable\nsecurity vulnerabilities.  Please see MS support for \ndetails:\n\nhttp://support.microsoft.com/default.aspx?scid=kb;[LN];301511");
        setSeverity(3);

        setKbKey("mssql/Version");
        setMatchRelease(true);
        setTestVersion("7.0.961");
    }
}
