/*
 * ExampleProbe.java
 *
 * Created on May 5, 2003, 7:26 AM
 */

package com.securitycentric.metacoretex.probes;

import com.securitycentric.metacoretex.lib.*;
import com.securitycentric.metacoretex.interfaces.*;

/**
 *
 * @author  visigoth
 */
public class ExampleProbe extends AbstractProbe {
    
    public ExampleProbe() {
        
        setName("Your Probe Name");

	/* the setFamily() method sets the probe family string which is used
	 * duing the GUI generation to group probes.
	 */
	setFamily("Your Family");

        setVersion("$Id: ExampleProbe.java,v 1.4 2003/09/21 22:44:36 visigoth_6 Exp $");
        setProbeId(666);
        
        /* This probe provides the KB key "your/info" which then must
         * be input using the kbPut() function at probetime.  The KB
         * value must be an Object, and should be described in the
         * second string for use by other developers/probes.
         */
        addProvides("your/info","Description of provided KB object");

        /* This method tells the dependency resolving subsystem to
         * make sure to fire this probe _after_ the probe which provides
         * this object.
         */
        addDepends("other/probe/info");
        
        /* These options will be user-configurable strings
         * which users may set via the UI
         */
        addOption("user_option","blah");
        
        /* Set the report string given back
         * remember, if your probe has something
         * to report, it must also setReportable(true)
         */
        setReport("This probe targets : ");

        /* Set the help information for this probe as seen from the
         * probe help interface in the UI.  Help should include a 
         * descr of the function of the probe, and explainations
         * for any user configurable options (addOption())
         */
        setHelp("This is an example probe from which one may "+
                "learn to write all kinds of nasty probes\n\n"+
                "Options:\n"+
                "user_option - This is a user configurable option "+
                "which can be set in the UI\n\n"+
                "Blah after options\n");
    }
    
    public boolean probe() throws ProbeException {

        /* If we depend on something, we should test for it
         * and return if we don't have it.  It is ok to
         * return silently because whatever probe was supposed
         * to put that here has likely already thrown a ProbeException
         */
        if (! kbHas("other/probe/info"))
            return;

        /* To test for a give port being open, use the following:
         * Don't forget to add addDepends("tcp/ports"); to the beginning

        if (kbHas("tcp/666")) {
            Boolean port = (Boolean)kbGet("tcp/666");
            if (! port.booleanValue())
                return;
         }

         * This way, if the "tcp/ports" providor didn't scan that port,
         * we run.  If it scanned, and found it closed, we don't.
         */

        /* Items in the KB are stored as Objects.  Probes must know
         * the appropriate class for the KB objects upon which they
         * depend and cast as appropriate
         */
        String kbString = (String)kbGet("other/probe/info");

        /* Probes are allowed to throw an exception in the event that
         * there is an inability to process.  Examples include, bad user
         * specified options, network failre, SQL errors, etc
         */
        if (horribleError)
            throw(new ProbeException("Encountered Horrible Error!"));

        /* The getHost() function will return a string of either hostname
         * or IP address for the current target.  Probes should use this
         * function to determine the target host.
         */
        addReport("Targeting " + getHost());

        /* If you said you provide something, be sure to
         * put it in the KB if you got it!
         */
        String myInfo = new String("visigoth rulez");
        kbPut("your/info",myInfo);

        return;
    }

    String blah = "obviously local class variables are allowed";
    boolean horribleError = false;
}
