/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema.transformer;

import com.sun.tools.xjc.reader.xmlschema.transformer.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

class VersionChecker
extends XMLFilterImpl {
    private String version = null;
    private boolean seenRoot = false;
    private boolean seenBindings = false;
    private Locator locator;

    public VersionChecker(XMLReader parent) {
        this.setParent(parent);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(namespaceURI, localName, qName, atts);
        if (!this.seenRoot) {
            this.seenRoot = true;
            this.version = atts.getValue("http://java.sun.com/xml/ns/jaxb", "version");
            if (namespaceURI.equals("http://java.sun.com/xml/ns/jaxb")) {
                String version2 = atts.getValue("", "version");
                if (this.version != null && version2 != null) {
                    SAXParseException e = new SAXParseException(Messages.format("Internalizer.TwoVersionAttributes"), this.locator);
                    this.getErrorHandler().error(e);
                }
                if (this.version == null) {
                    this.version = version2;
                }
            }
        }
        if ("http://java.sun.com/xml/ns/jaxb".equals(namespaceURI)) {
            this.seenBindings = true;
        }
    }

    public void endDocument() throws SAXException {
        SAXParseException e;
        super.endDocument();
        if (this.seenBindings && this.version == null) {
            e = new SAXParseException(Messages.format("Internalizer.VersionNotPresent"), this.locator);
            this.getErrorHandler().error(e);
        }
        if (this.version != null && !this.version.equals("1.0")) {
            e = new SAXParseException(Messages.format("Internalizer.IncorrectVersion"), this.locator);
            this.getErrorHandler().error(e);
        }
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }
}

