/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema.transformer;

import com.sun.tools.xjc.reader.xmlschema.transformer.DOMForest;
import com.sun.tools.xjc.reader.xmlschema.transformer.Messages;
import com.sun.tools.xjc.util.DOMUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Internalizer {
    private final DOMForest forest;
    private ErrorHandler errorHandler;
    private static final String EXTENSION_PREFIXES = "extensionBindingPrefixes";

    public static void transform(DOMForest forest, ErrorHandler handler) throws SAXException {
        new Internalizer(forest, handler).transform();
    }

    private Internalizer(DOMForest forest, ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.forest = forest;
    }

    private void transform() throws SAXException {
        HashMap targetNodes = new HashMap();
        Iterator itr = this.forest.outerMostBindings.iterator();
        while (itr.hasNext()) {
            Element jaxbBindings = (Element)itr.next();
            this.buildTargetNodeMap(jaxbBindings, jaxbBindings, targetNodes);
        }
        Iterator itr2 = this.forest.outerMostBindings.iterator();
        while (itr2.hasNext()) {
            Element jaxbBindings = (Element)itr2.next();
            this.move(jaxbBindings, targetNodes);
        }
    }

    private void validate(Element bindings) throws SAXException {
        boolean hasSchemaLocation = false;
        boolean hasNode = false;
        NamedNodeMap atts = bindings.getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            Attr a = (Attr)atts.item(i);
            if (a.getNamespaceURI() == null) {
                if (a.getLocalName().equals("node")) {
                    hasNode = true;
                } else if (a.getLocalName().equals("schemaLocation")) {
                    hasSchemaLocation = true;
                }
            }
            ++i;
        }
    }

    private void buildTargetNodeMap(Element bindings, Node inheritedTarget, Map result) throws SAXException {
        Node target = inheritedTarget;
        this.validate(bindings);
        if (bindings.getAttributeNode("schemaLocation") != null) {
            String schemaLocation = bindings.getAttribute("schemaLocation");
            try {
                schemaLocation = new URL(new URL(this.forest.getSystemId(bindings.getOwnerDocument())), schemaLocation).toExternalForm();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            target = this.forest.get(schemaLocation);
            if (target == null) {
                this.reportError(bindings, Messages.format("Internalizer.IncorrectSchemaReference", schemaLocation));
                return;
            }
        }
        if (bindings.getAttributeNode("node") != null) {
            NodeList nlst;
            String nodeXPath = bindings.getAttribute("node");
            try {
                nlst = XPathAPI.selectNodeList((Node)target, (String)nodeXPath, (Node)bindings);
            }
            catch (TransformerException e) {
                this.reportError(bindings, Messages.format("Internalizer.XPathEvaluationError", e.getMessage()), e);
                return;
            }
            if (nlst.getLength() == 0) {
                this.reportError(bindings, Messages.format("Internalizer.XPathEvaluatesToNoTarget", nodeXPath));
                return;
            }
            if (nlst.getLength() != 1) {
                this.reportError(bindings, Messages.format("Internalizer.XPathEvaulatesToTooManyTargets", nodeXPath, new Integer(nlst.getLength())));
                return;
            }
            Node rnode = nlst.item(0);
            if (!(rnode instanceof Element)) {
                this.reportError(bindings, Messages.format("Internalizer.XPathEvaluatesToNonElement", nodeXPath));
                return;
            }
            if (!"http://www.w3.org/2001/XMLSchema".equals(rnode.getNamespaceURI())) {
                this.reportError(bindings, Messages.format("Internalizer.XPathEvaluatesToNonXSDElement", nodeXPath, rnode.getNodeName()));
                return;
            }
            target = (Element)rnode;
        }
        result.put(bindings, target);
        Element[] children = DOMUtils.getChildElements(bindings, "http://java.sun.com/xml/ns/jaxb", "bindings");
        int i = 0;
        while (i < children.length) {
            this.buildTargetNodeMap(children[i], target, result);
            ++i;
        }
    }

    private void move(Element bindings, Map targetNodes) throws SAXException {
        Node target = (Node)targetNodes.get(bindings);
        if (target == null) {
            return;
        }
        Element[] children = DOMUtils.getChildElements(bindings);
        int i = 0;
        while (i < children.length) {
            Element item = children[i];
            if ("bindings".equals(item.getLocalName())) {
                this.move(item, targetNodes);
            } else {
                if (!(target instanceof Element)) {
                    this.reportError(item, Messages.format("Internalizer.ContextNodeIsNotElement"));
                    return;
                }
                this.moveUnder(item, (Element)target);
            }
            ++i;
        }
    }

    private void moveUnder(Element decl, Element target) {
        Element appinfo;
        Element annotation2 = DOMUtils.getFirstChildElement(target, "http://www.w3.org/2001/XMLSchema", "annotation");
        if (annotation2 == null) {
            annotation2 = this.insertXMLSchemaElement(target, "annotation");
        }
        if ((appinfo = DOMUtils.getFirstChildElement(annotation2, "http://www.w3.org/2001/XMLSchema", "appinfo")) == null) {
            appinfo = this.insertXMLSchemaElement(annotation2, "appinfo");
        }
        if (!"http://java.sun.com/xml/ns/jaxb".equals(decl.getNamespaceURI())) {
            this.declareExtensionNamespace(target, decl.getNamespaceURI());
        }
        Element p = decl;
        HashSet<String> inscopes = new HashSet<String>();
        while (true) {
            NamedNodeMap atts = p.getAttributes();
            int i = 0;
            while (i < atts.getLength()) {
                String prefix;
                Attr a = (Attr)atts.item(i);
                if ("http://www.w3.org/2000/xmlns/".equals(a.getNamespaceURI()) && inscopes.add(prefix = a.getName().indexOf(58) == -1 ? "" : a.getLocalName()) && p != decl) {
                    decl.setAttributeNodeNS((Attr)a.cloneNode(true));
                }
                ++i;
            }
            if (p.getParentNode() instanceof Document) break;
            p = (Element)p.getParentNode();
        }
        if (!inscopes.contains("")) {
            decl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
        if (appinfo.getOwnerDocument() != decl.getOwnerDocument()) {
            Element original = decl;
            decl = (Element)appinfo.getOwnerDocument().importNode(decl, true);
            this.copyLocators(original, decl);
        }
        appinfo.appendChild(decl);
    }

    private void declareExtensionNamespace(Element target, String nsUri) {
        Element root = target.getOwnerDocument().getDocumentElement();
        Attr att = root.getAttributeNodeNS("http://java.sun.com/xml/ns/jaxb", EXTENSION_PREFIXES);
        if (att == null) {
            String jaxbPrefix = this.allocatePrefix(root, "http://java.sun.com/xml/ns/jaxb");
            att = target.getOwnerDocument().createAttributeNS("http://java.sun.com/xml/ns/jaxb", jaxbPrefix + ":" + EXTENSION_PREFIXES);
            root.setAttributeNodeNS(att);
        }
        String prefix = this.allocatePrefix(root, nsUri);
        if (att.getValue().indexOf(prefix) == -1) {
            att.setValue(att.getValue() + " " + prefix);
        }
    }

    private String allocatePrefix(Element e, String nsUri) {
        String prefix;
        NamedNodeMap atts = e.getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            Attr a = (Attr)atts.item(i);
            if ("http://www.w3.org/2000/xmlns/".equals(a.getNamespaceURI()) && a.getName().indexOf(58) != -1 && a.getValue().equals(nsUri)) {
                return a.getLocalName();
            }
            ++i;
        }
        while (e.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", prefix = "p" + (int)(Math.random() * 1000000.0) + "_") != null) {
        }
        e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsUri);
        return prefix;
    }

    private Element insertXMLSchemaElement(Element parent, String localName) {
        String qname2 = parent.getTagName();
        int idx = qname2.indexOf(58);
        qname2 = idx == -1 ? localName : qname2.substring(0, idx + 1) + localName;
        Element child = parent.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", qname2);
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 0) {
            parent.appendChild(child);
        } else {
            parent.insertBefore(child, children.item(0));
        }
        return child;
    }

    private void copyLocators(Element src, Element dst) {
        this.forest.locatorTable.storeStartLocation(dst, this.forest.locatorTable.getStartLocation(src));
        this.forest.locatorTable.storeEndLocation(dst, this.forest.locatorTable.getEndLocation(src));
        Element[] srcChilds = DOMUtils.getChildElements(src);
        Element[] dstChilds = DOMUtils.getChildElements(dst);
        int i = 0;
        while (i < srcChilds.length) {
            this.copyLocators(srcChilds[i], dstChilds[i]);
            ++i;
        }
    }

    private void reportError(Element errorSource, String formattedMsg) throws SAXException {
        this.reportError(errorSource, formattedMsg, null);
    }

    private void reportError(Element errorSource, String formattedMsg, Exception nestedException) throws SAXException {
        SAXParseException e = new SAXParseException(formattedMsg, this.forest.locatorTable.getStartLocation(errorSource), nestedException);
        this.errorHandler.error(e);
    }
}

