/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema.transformer;

import com.sun.tools.xjc.reader.xmlschema.transformer.DOMBuilder;
import com.sun.tools.xjc.reader.xmlschema.transformer.LocatorTable;
import com.sun.tools.xjc.reader.xmlschema.transformer.Messages;
import com.sun.tools.xjc.reader.xmlschema.transformer.VersionChecker;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public final class DOMForest {
    private final Map core = new HashMap();
    public final LocatorTable locatorTable = new LocatorTable();
    public final Set outerMostBindings = new HashSet();
    private EntityResolver entityResolver = null;
    private ErrorHandler errorHandler = null;
    private final SAXParserFactory parserFactory;
    private final DocumentBuilder documentBuilder;

    public DOMForest(SAXParserFactory parserFactory, DocumentBuilder documentBuilder) {
        this.parserFactory = parserFactory;
        this.documentBuilder = documentBuilder;
    }

    public Document get(String systemId) {
        Document doc = (Document)this.core.get(systemId);
        if (doc == null && systemId.startsWith("file:/") && !systemId.startsWith("file://")) {
            doc = (Document)this.core.get("file://" + systemId.substring(5));
        }
        return doc;
    }

    public String getSystemId(Document dom) {
        Iterator itr = this.core.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            if (e.getValue() != dom) continue;
            return (String)e.getKey();
        }
        return null;
    }

    public Document parse(InputSource source) throws SAXException, IOException {
        if (source.getSystemId() == null) {
            throw new IllegalArgumentException();
        }
        return this.parse(source.getSystemId(), source);
    }

    public Document parse(String systemId) throws SAXException, IOException {
        if (this.core.containsKey(systemId)) {
            return (Document)this.core.get(systemId);
        }
        InputSource is = null;
        if (this.entityResolver != null) {
            is = this.entityResolver.resolveEntity(null, systemId);
        }
        if (is == null) {
            is = new InputSource(systemId);
        }
        return this.parse(systemId, is);
    }

    public Document parse(String systemId, InputSource inputSource) throws SAXException, IOException {
        Document dom = this.documentBuilder.newDocument();
        this.core.put(systemId, dom);
        try {
            XMLReader reader = this.parserFactory.newSAXParser().getXMLReader();
            reader = new ReferenceFinder(reader);
            reader = new VersionChecker(reader);
            reader.setContentHandler(new DOMBuilder(dom, this.locatorTable, this.outerMostBindings));
            if (this.errorHandler != null) {
                reader.setErrorHandler(this.errorHandler);
            }
            if (this.entityResolver != null) {
                reader.setEntityResolver(this.entityResolver);
            }
            reader.parse(inputSource);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return dom;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void dump(OutputStream out) throws IOException {
        try {
            Transformer it = TransformerFactory.newInstance().newTransformer();
            Iterator itr = this.core.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry e = itr.next();
                out.write(("---<< " + e.getKey() + "\n").getBytes());
                it.transform(new DOMSource((Document)e.getValue()), new StreamResult(out));
                out.write("\n\n\n".getBytes());
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private class ReferenceFinder
    extends XMLFilterImpl {
        private Locator locator;

        ReferenceFinder(XMLReader parent) {
            this.setParent(parent);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, qName, atts);
            if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI) && ("import".equals(localName) || "include".equals(localName))) {
                String relativeRef = atts.getValue("schemaLocation");
                if (relativeRef == null) {
                    return;
                }
                try {
                    String ref = new URL(new URL(this.locator.getSystemId()), relativeRef).toExternalForm();
                    DOMForest.this.parse(ref);
                }
                catch (IOException e) {
                    SAXParseException spe = new SAXParseException(Messages.format("DOMForest.UnableToParse", relativeRef), this.locator, e);
                    if (DOMForest.this.errorHandler != null) {
                        DOMForest.this.errorHandler.fatalError(spe);
                    }
                    throw spe;
                }
            }
        }

        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.locator = locator;
        }
    }
}

