/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.msv.reader.Controller;
import com.sun.tools.xjc.ConsoleErrorReporter;
import com.sun.tools.xjc.util.ErrorHandlerFilter;
import java.io.File;
import java.io.IOException;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.ErrorHandlerWrapper;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class SchemaConstraintChecker {
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public static boolean check(InputSource[] schemas, ErrorHandler errorHandler) throws IOException {
        XMLGrammarPreparser preparser = new XMLGrammarPreparser();
        preparser.registerPreparser(XML_SCHEMA, null);
        preparser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        ErrorHandlerFilter filter = new ErrorHandlerFilter(errorHandler);
        preparser.setErrorHandler((XMLErrorHandler)new ErrorHandlerWrapper((ErrorHandler)filter));
        int i = 0;
        while (i < schemas.length) {
            preparser.preparseGrammar(XML_SCHEMA, SchemaConstraintChecker.createXMLInputSource(schemas[i]));
            ++i;
        }
        return !filter.hadError();
    }

    private static XMLInputSource createXMLInputSource(InputSource is) {
        XMLInputSource xis = new XMLInputSource(is.getPublicId(), is.getSystemId(), null);
        xis.setByteStream(is.getByteStream());
        xis.setCharacterStream(is.getCharacterStream());
        xis.setEncoding(is.getEncoding());
        return xis;
    }

    public static void main(String[] args) throws IOException {
        InputSource[] sources = new InputSource[args.length];
        int i = 0;
        while (i < args.length) {
            sources[i] = new InputSource(new File(args[i]).toURL().toExternalForm());
            ++i;
        }
        SchemaConstraintChecker.check(sources, new Controller(new ConsoleErrorReporter()));
    }
}

