/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.ErrorType;
import com.sun.msv.datatype.xsd.TypeIncubator;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.tools.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.xjc.reader.xmlschema.Const;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.visitor.XSSimpleTypeFunction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.relaxng.datatype.DatatypeException;

class DatatypeBuilder
implements XSSimpleTypeFunction {
    private final BGMBuilder builder;
    private final Map cache = new HashMap();

    DatatypeBuilder(BGMBuilder builder, XSSchemaSet schemas) {
        this.builder = builder;
        try {
            int i = 0;
            while (i < Const.builtinTypeNames.length) {
                XSSimpleType type = schemas.getSimpleType("http://www.w3.org/2001/XMLSchema", Const.builtinTypeNames[i]);
                DatatypeBuilder._assert(type != null);
                this.cache.put(type, DatatypeFactory.getTypeByName(Const.builtinTypeNames[i]));
                ++i;
            }
        }
        catch (DatatypeException e) {
            e.printStackTrace();
            DatatypeBuilder._assert(false);
        }
    }

    public XSDatatype build(XSSimpleType type) {
        return (XSDatatype)type.apply(this);
    }

    public Object restrictionSimpleType(XSRestrictionSimpleType type) {
        XSDatatype dt = (XSDatatype)this.cache.get(type);
        if (dt != null) {
            return dt;
        }
        try {
            TypeIncubator ti = new TypeIncubator(this.build(type.getSimpleBaseType()));
            Iterator itr = type.iterateDeclaredFacets();
            while (itr.hasNext()) {
                XSFacet facet2 = (XSFacet)itr.next();
                ti.addFacet(facet2.getName(), facet2.getValue(), facet2.isFixed(), facet2.getContext());
            }
            dt = ti.derive(type.getName());
            this.cache.put(type, dt);
            return dt;
        }
        catch (DatatypeException e) {
            this.builder.errorReporter.error(type.getLocator(), "DatatypeBuilder.DatatypeError", e.getMessage());
            return ErrorType.theInstance;
        }
    }

    public Object listSimpleType(XSListSimpleType type) {
        XSDatatype dt = (XSDatatype)this.cache.get(type);
        if (dt != null) {
            return dt;
        }
        try {
            dt = DatatypeFactory.deriveByList(type.getName(), this.build(type.getItemType()));
            this.cache.put(type, dt);
            return dt;
        }
        catch (DatatypeException e) {
            this.builder.errorReporter.error(type.getLocator(), "DatatypeBuilder.DatatypeError", e.getMessage());
            return ErrorType.theInstance;
        }
    }

    public Object unionSimpleType(XSUnionSimpleType type) {
        XSDatatype dt = (XSDatatype)this.cache.get(type);
        if (dt != null) {
            return dt;
        }
        try {
            XSDatatype[] members = new XSDatatype[type.getMemberSize()];
            int i = 0;
            while (i < members.length) {
                members[i] = this.build(type.getMember(i));
                ++i;
            }
            dt = DatatypeFactory.deriveByUnion(type.getName(), members);
            this.cache.put(type, dt);
            return dt;
        }
        catch (DatatypeException e) {
            this.builder.errorReporter.error(type.getLocator(), "DatatypeBuilder.DatatypeError", e.getMessage());
            return ErrorType.theInstance;
        }
    }

    private static final void _assert(boolean b) {
        if (!b) {
            throw new InternalError("assertion failed");
        }
    }
}

