/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.msv.util.StringPair;
import com.sun.tools.xjc.reader.xmlschema.Messages;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.XMLFilterImpl;

public class CustomizationContextChecker
extends XMLFilterImpl {
    private final Stack elementNames = new Stack();
    private final ErrorHandler errorHandler;
    private Locator locator;
    private static final Set prohibitedSchemaElementNames = new HashSet();

    public CustomizationContextChecker(ErrorHandler _errorHandler) {
        this.errorHandler = _errorHandler;
    }

    private StringPair top() {
        return (StringPair)this.elementNames.peek();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        StringPair newElement = new StringPair(namespaceURI, localName);
        if (newElement.namespaceURI.equals("http://java.sun.com/xml/ns/jaxb") && this.top().namespaceURI.equals("http://www.w3.org/2001/XMLSchema") && this.elementNames.size() >= 3) {
            StringPair schemaElement = (StringPair)this.elementNames.get(this.elementNames.size() - 3);
            if (prohibitedSchemaElementNames.contains(schemaElement.localName)) {
                this.errorHandler.error(new SAXParseException(Messages.format("UnusedCustomizationChecker.UnacknolwedgedCustomization", localName), this.locator));
            }
        }
        this.elementNames.push(newElement);
        super.startElement(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(namespaceURI, localName, qName);
        this.elementNames.pop();
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    static {
        prohibitedSchemaElementNames.add("restriction");
        prohibitedSchemaElementNames.add("extension");
        prohibitedSchemaElementNames.add("simpleContent");
        prohibitedSchemaElementNames.add("complexContent");
        prohibitedSchemaElementNames.add("list");
        prohibitedSchemaElementNames.add("union");
    }
}

