/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.msv.datatype.xsd.BooleanType;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.trex.ElementPattern;
import com.sun.tools.xjc.grammar.BGMWalker;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.SuperClassItem;
import com.sun.tools.xjc.grammar.WildcardItem;
import com.sun.tools.xjc.reader.xmlschema.AbstractXSFunctionImpl;
import com.sun.tools.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.xjc.reader.xmlschema.WildcardNameClassBuilder;
import com.sun.xml.xsom.XSAttContainer;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSWildcard;
import java.util.Iterator;
import org.relaxng.datatype.ValidationContext;

final class AGMFragmentBuilder
extends AbstractXSFunctionImpl {
    private final BGMBuilder builder;
    private final ExpressionPool pool;
    private ClassItem superClass;

    AGMFragmentBuilder(BGMBuilder builder) {
        this.builder = builder;
        this.pool = builder.pool;
    }

    public Expression build(XSComponent sc, ClassItem owner) {
        this.superClass = this.findSuperClass(owner);
        return (Expression)sc.apply(this);
    }

    public Object attGroupDecl(XSAttGroupDecl decl) {
        return this.attributeContainer(decl);
    }

    private Expression attributeContainer(XSAttContainer cont) {
        Expression exp = Expression.epsilon;
        Iterator itr = cont.iterateAttGroups();
        while (itr.hasNext()) {
            exp = this.pool.createSequence(exp, this.recurse((XSAttGroupDecl)itr.next()));
        }
        Iterator itr2 = cont.iterateDeclaredAttributeUses();
        while (itr2.hasNext()) {
            exp = this.pool.createSequence(exp, this.recurse((XSAttributeUse)itr2.next()));
        }
        return exp;
    }

    public Object attributeDecl(XSAttributeDecl decl) {
        return this.attribute(decl, decl.getFixedValue(), decl.getContext());
    }

    private Expression attribute(XSAttributeDecl decl, String fixedValue, ValidationContext context) {
        SimpleNameClass name = new SimpleNameClass(decl.getTargetNamespace(), decl.getName());
        XSDatatype dt = this.builder.simpleTypeBuilder.datatypeBuilder.build(decl.getType());
        if (fixedValue != null) {
            Object value = dt.createValue(fixedValue, context);
            return this.pool.createAttribute(name, this.pool.createValue(dt, null, value));
        }
        return this.pool.createAttribute(name, this.pool.createData(dt, null));
    }

    public Object attributeUse(XSAttributeUse use) {
        Expression e = this.attribute(use.getDecl(), use.getFixedValue(), use.getContext());
        if (use.isRequired()) {
            return e;
        }
        return this.pool.createOptional(e);
    }

    public Object complexType(XSComplexType type) {
        Expression body;
        XSContentType content = type.getContentType();
        if (content.asEmpty() != null) {
            body = Expression.epsilon;
            if (type.getDerivationMethod() == 1) {
                body = this.recurse(type.getBaseType());
            }
        } else if (content.asParticle() != null) {
            body = this.recurse(content);
        } else if (content.asSimpleType() != null) {
            body = type.getDerivationMethod() == 1 ? this.recurse(type.getBaseType()) : this.recurse(content);
        } else {
            throw new InternalError("unknown content type");
        }
        if (type.isMixed()) {
            body = this.pool.createMixed(body);
        }
        body = this.pool.createSequence(body, this.attributeContainer(type));
        return body;
    }

    public Object empty(XSContentType empty) {
        return Expression.epsilon;
    }

    public Object particle(XSParticle particle2) {
        Expression e;
        XSTerm t = particle2.getTerm();
        if (this.builder.particlesWithGlobalElementSkip.contains(particle2)) {
            e = (Expression)t.apply(this);
            if (t.asElementDecl().getType().isComplexType()) {
                e = this.pool.createChoice(e, this.recurse(t));
            }
        } else {
            e = this.recurse(t);
        }
        return this.builder.processMinMax(e, particle2);
    }

    public Object simpleType(XSSimpleType simpleType2) {
        return this.pool.createData(this.builder.simpleTypeBuilder.datatypeBuilder.build(simpleType2));
    }

    public Object elementDecl(XSElementDecl decl) {
        this.builder.checkAbstractComplexType(decl);
        Expression body = this.recurse(decl.getType());
        if (decl.isNillable()) {
            body = this.pool.createChoice(body, this.pool.createAttribute(new SimpleNameClass("http://www.w3.org/2001/XMLSchema-instance", "nil"), this.pool.createValue(BooleanType.theInstance, Boolean.TRUE)));
        }
        return new ElementPattern(new SimpleNameClass(decl.getTargetNamespace(), decl.getName()), body);
    }

    public Object modelGroup(XSModelGroup group2) {
        XSModelGroup.Compositor comp = group2.getCompositor();
        Expression exp = comp == XSModelGroup.CHOICE ? Expression.nullSet : Expression.epsilon;
        int i = 0;
        while (i < group2.getSize()) {
            Expression item = this.recurse(group2.getChild(i));
            if (comp == XSModelGroup.CHOICE) {
                exp = this.pool.createChoice(exp, item);
            }
            if (comp == XSModelGroup.SEQUENCE) {
                exp = this.pool.createSequence(exp, item);
            }
            if (comp == XSModelGroup.ALL) {
                exp = this.pool.createInterleave(exp, item);
            }
            ++i;
        }
        return exp;
    }

    public Object modelGroupDecl(XSModelGroupDecl decl) {
        return this.recurse(decl.getModelGroup());
    }

    public Object wildcard(XSWildcard wc) {
        return new WildcardItem(this.builder.grammar.codeModel, WildcardNameClassBuilder.build(wc), wc.getMode() == 2);
    }

    private Expression recurse(XSComponent sc) {
        ClassItem cls = this.builder.selector.select(sc);
        if (cls != null) {
            if (this.superClass == cls) {
                return cls.getAGM();
            }
            return cls;
        }
        return (Expression)sc.apply(this);
    }

    private ClassItem findSuperClass(ClassItem parent) {
        final ClassItem[] result = new ClassItem[1];
        parent.exp.visit(new BGMWalker(){
            private boolean inSuper;

            public Object onClass(ClassItem item) {
                if (this.inSuper) {
                    result[0] = item;
                }
                return null;
            }

            public Object onSuper(SuperClassItem item) {
                this.inSuper = true;
                item.exp.visit(this);
                this.inSuper = false;
                return null;
            }
        });
        return result[0];
    }
}

