/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.dtd;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.IDREFType;
import com.sun.msv.datatype.xsd.IDType;
import com.sun.msv.datatype.xsd.StringType;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.reader.AbortException;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.dtd.DTDReader;
import com.sun.msv.scanner.dtd.DTDParser;
import com.sun.msv.scanner.dtd.InputEntity;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.InterfaceItem;
import com.sun.tools.xjc.grammar.PrimitiveItem;
import com.sun.tools.xjc.grammar.TypeItem;
import com.sun.tools.xjc.grammar.id.IDREFTransducer;
import com.sun.tools.xjc.grammar.id.IDTransducer;
import com.sun.tools.xjc.reader.NameConverter;
import com.sun.tools.xjc.reader.PackageTracker;
import com.sun.tools.xjc.reader.annotator.Annotator;
import com.sun.tools.xjc.reader.annotator.AnnotatorController;
import com.sun.tools.xjc.reader.annotator.DatatypeSimplifier;
import com.sun.tools.xjc.reader.dtd.Messages;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIAttribute;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIContent;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIConversion;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIElement;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIInterface;
import com.sun.tools.xjc.reader.dtd.bindinfo.BindInfo;
import com.sun.tools.xjc.util.CodeModelClassFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.relaxng.datatype.DatatypeException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TDTDReader
extends DTDReader
implements AnnotatorController,
PackageTracker {
    private AnnotatedGrammar annGrammar;
    private final BindInfo bindInfo;
    private final JCodeModel codeModel = new JCodeModel();
    private final CodeModelClassFactory classFactory;
    private final DatatypeSimplifier dtsimplifier;

    public static AnnotatedGrammar parse(InputSource dtd, InputSource bindingInfo, GrammarReaderController controller, ExpressionPool pool) {
        try {
            TDTDReader reader = new TDTDReader(controller, pool, bindingInfo);
            DTDParser parser = new DTDParser();
            parser.setDtdHandler(reader);
            parser.setEntityResolver(controller);
            try {
                parser.parse(dtd);
            }
            catch (SAXParseException e) {
                return null;
            }
            return reader.getAnnotatedResult();
        }
        catch (IOException e) {
            controller.error(new Locator[0], e.getMessage(), e);
            return null;
        }
        catch (SAXException e) {
            controller.error(new Locator[0], e.getMessage(), e);
            return null;
        }
        catch (AbortException e) {
            return null;
        }
    }

    protected TDTDReader(GrammarReaderController _controller, ExpressionPool pool, InputSource _bindInfo) throws AbortException {
        super(_controller, pool);
        this.dtsimplifier = new DatatypeSimplifier(this.grammar.pool);
        this.bindInfo = new BindInfo(_bindInfo, this.controller, this.codeModel);
        this.classFactory = new CodeModelClassFactory(this.controller);
    }

    public AnnotatedGrammar getAnnotatedResult() {
        if (this.controller.hadError()) {
            return null;
        }
        return this.annGrammar;
    }

    public void startDTD(InputEntity entity) throws SAXException {
        super.startDTD(entity);
        this.annGrammar = new AnnotatedGrammar(this.grammar, this.codeModel);
    }

    public void endDTD() throws SAXException {
        super.endDTD();
        if (this.controller.hadError()) {
            return;
        }
        this.resetStartPattern();
        this.processInterfaceDeclarations();
        this.annGrammar.topLevel = this.grammar.getTopLevel();
        Annotator.annotate(this.annGrammar, this);
        this.processConstructorDeclarations();
    }

    private void resetStartPattern() {
        Expression exp = Expression.nullSet;
        Iterator itr = this.bindInfo.elements();
        while (itr.hasNext()) {
            BIElement e = (BIElement)itr.next();
            if (!e.isRoot()) continue;
            ReferenceExp rexp = this.grammar.namedPatterns.getOrCreate(e.name());
            if (!rexp.isDefined()) {
                this.error(e.getSourceLocation(), "TDTDReader.UndefinedElementInBindInfo", (Object)e.name());
                continue;
            }
            exp = this.grammar.pool.createChoice(exp, rexp);
        }
        if (exp != Expression.nullSet) {
            this.grammar.exp = exp;
        }
    }

    private void processInterfaceDeclarations() {
        HashMap<BIInterface, InterfaceItem> decls = new HashMap<BIInterface, InterfaceItem>();
        Iterator itr = this.bindInfo.interfaces();
        while (itr.hasNext()) {
            BIInterface decl = (BIInterface)itr.next();
            decls.put(decl, this.annGrammar.createInterfaceItem(this.classFactory.createInterface(this.bindInfo.getTargetPackage(), decl.name(), this.locator), Expression.nullSet));
        }
        HashMap<String, TypeItem> fromName = new HashMap<String, TypeItem>();
        itr = this.annGrammar.iterateClasses();
        while (itr.hasNext()) {
            ClassItem ci = (ClassItem)itr.next();
            fromName.put(ci.getTypeAsDefined().name(), ci);
        }
        itr = this.annGrammar.iterateInterfaces();
        while (itr.hasNext()) {
            InterfaceItem itf = (InterfaceItem)itr.next();
            fromName.put(itf.getTypeAsClass().name(), itf);
        }
        itr = decls.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            BIInterface decl = (BIInterface)e.getKey();
            InterfaceItem item = (InterfaceItem)e.getValue();
            String[] members = decl.members();
            int i = 0;
            while (i < members.length) {
                Expression exp = (Expression)fromName.get(members[i]);
                if (exp == null) {
                    this.error(decl.getSourceLocation(), "TDTDReader.BindInfo.NonExistentInterfaceMember", (Object)members[i]);
                } else {
                    item.exp = this.annGrammar.getPool().createChoice(item.exp, exp);
                }
                ++i;
            }
        }
    }

    private void processConstructorDeclarations() {
        Iterator itr = this.bindInfo.elements();
        while (itr.hasNext()) {
            BIElement decl = (BIElement)itr.next();
            ReferenceExp rexp = this.grammar.namedPatterns._get(decl.name());
            if (rexp == null) {
                this.error(decl.getSourceLocation(), "TDTDReader.BindInfo.NonExistentElementDeclaration", (Object)decl.name());
                continue;
            }
            if (!decl.isClass()) continue;
            TDTDReader._assert(rexp.exp instanceof ClassItem);
            ClassItem ci = (ClassItem)rexp.exp;
            decl.declareConstructors(ci, this);
        }
    }

    protected Expression createAttributeBody(String elementName, String attributeName, String attributeType, String[] enums, short attributeUse, String defaultValue) throws SAXException {
        Expression exp = super.createAttributeBody(elementName, attributeName, attributeType, enums, attributeUse, defaultValue);
        BIElement edecl = this.bindInfo.element(elementName);
        BIAttribute decl = null;
        if (edecl != null) {
            decl = edecl.attribute(attributeName);
        }
        if (decl != null) {
            BIConversion conv = decl.getConversion();
            if (conv != null) {
                exp = new PrimitiveItem(conv.getTransducer(), (DatabindableDatatype)StringType.theInstance, exp);
            }
            FieldItem fi = new FieldItem(decl.getPropertyName(), exp, this.locator);
            fi.realization = decl.getRealization();
            exp = fi;
        } else {
            if (attributeType.equals("ID")) {
                exp = new PrimitiveItem(new IDTransducer(this.codeModel, this.annGrammar.defaultSymbolSpace), (DatabindableDatatype)IDType.theInstance, exp);
            }
            if (attributeType.equals("IDREF")) {
                exp = new PrimitiveItem(new IDREFTransducer(this.codeModel, this.annGrammar.defaultSymbolSpace), (DatabindableDatatype)IDREFType.theInstance, exp);
            }
            if (attributeType.equals("IDREFS")) {
                try {
                    exp = this.grammar.pool.createList(this.grammar.pool.createOneOrMore(new PrimitiveItem(new IDREFTransducer(this.codeModel, this.annGrammar.defaultSymbolSpace), (DatabindableDatatype)DatatypeFactory.getTypeByName("IDREFS"), this.grammar.pool.createData(IDREFType.theInstance))));
                }
                catch (DatatypeException e) {
                    e.printStackTrace();
                    throw new InternalError();
                }
            }
            exp = new FieldItem(NameConverter.standard.toPropertyName(attributeName), exp, this.locator);
        }
        return exp;
    }

    protected ReferenceExp createElementDeclaration(String elementName) {
        BIElement decl = this.bindInfo.element(elementName);
        if (decl == null || decl.isClass()) {
            this.elementDecls.put(elementName, this.performContentAnnotation(elementName, decl, (Expression)this.elementDecls.get(elementName)));
        }
        ReferenceExp exp = super.createElementDeclaration(elementName);
        ElementExp eexp = (ElementExp)exp.exp;
        if (decl == null || decl.isClass()) {
            JDefinedClass clazz = decl != null ? decl.getClassObject() : this.classFactory.createInterface(this.bindInfo.getTargetPackage(), this.getNameConverter().toClassName(elementName), this.locator);
            ClassItem t = this.annGrammar.createClassItem(clazz, eexp);
            this.setDeclaredLocationOf(t);
            if (decl == null) {
                t.isTemporary = true;
            }
            exp.exp = t;
        } else {
            BIConversion cnv;
            if (eexp.contentModel != Expression.anyString) {
                this.error((Expression)eexp, "TDTDReader.ConversionForNonValueElement", (Object)elementName);
            }
            if ((cnv = decl.getConversion()) != null) {
                PrimitiveItem pi = new PrimitiveItem(cnv.getTransducer(), (DatabindableDatatype)StringType.theInstance, (Expression)eexp);
                exp.exp = pi;
            } else {
                PrimitiveItem pi = new PrimitiveItem(this.codeModel, (DatabindableDatatype)StringType.theInstance, (Expression)eexp);
                exp.exp = pi;
            }
        }
        return exp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression performContentAnnotation(String elementName, BIElement decl, Expression exp) {
        BIContent restDecl;
        if (exp == Expression.anyString && decl == null) {
            return exp;
        }
        if (exp == Expression.epsilon) {
            return exp;
        }
        Expression[] children = exp instanceof SequenceExp ? ((SequenceExp)exp).getChildren() : new Expression[]{exp};
        int idx = 0;
        Expression newContentModel = Expression.epsilon;
        if (decl != null) {
            Iterator itr = decl.iterateContents();
            while (itr.hasNext()) {
                try {
                    BIContent bic = (BIContent)itr.next();
                    if (idx == children.length) {
                        throw new BIContent.MismatchException();
                    }
                    newContentModel = this.grammar.pool.createSequence(newContentModel, bic.wrap(children[idx]));
                    ++idx;
                }
                catch (BIContent.MismatchException mme) {
                    this.error(exp, "TDTDReader.ContentProperty.ParticleMismatch", (Object)elementName);
                }
            }
        }
        BIContent bIContent = restDecl = decl != null ? decl.getRest() : null;
        if (restDecl != null) {
            Expression rest = Expression.epsilon;
            while (idx < children.length) {
                rest = this.grammar.pool.createSequence(rest, children[idx++]);
            }
            FieldItem fi = new FieldItem(restDecl.getPropertyName(), rest, restDecl.getType(), this.locator);
            fi.realization = restDecl.getRealization();
            rest = fi;
            return this.grammar.pool.createSequence(newContentModel, rest);
        }
        int i = idx;
        while (i < children.length) {
            if (!(children[i].peelOccurence() instanceof ReferenceExp)) break;
            ++i;
        }
        if (i != children.length) {
            if (idx == 0) {
                return new FieldItem("Content", exp, this.locator);
            }
            this.error(exp, "TDTDReader.ContentProperty.DeclarationTooShort", (Object)elementName);
            return Expression.nullSet;
        }
        i = idx;
        while (i < children.length) {
            newContentModel = this.grammar.pool.createSequence(newContentModel, new FieldItem(NameConverter.standard.toPropertyName(((ReferenceExp)children[i].peelOccurence()).name), children[i], this.locator));
            ++i;
        }
        return newContentModel;
    }

    public JPackage get(ReferenceExp exp) {
        return this.bindInfo.getTargetPackage();
    }

    public NameConverter getNameConverter() {
        return NameConverter.standard;
    }

    public PackageTracker getPackageTracker() {
        return this;
    }

    public void reportError(Expression[] srcs, String msg) {
        Vector<Locator> vec = new Vector<Locator>();
        int i = 0;
        while (i < srcs.length) {
            Locator loc = this.getDeclaredLocationOf(srcs[i]);
            if (loc != null) {
                vec.add(loc);
            }
            ++i;
        }
        this.reportError(vec.toArray(new Locator[0]), msg);
    }

    public void reportError(Locator[] locs, String msg) {
        this.controller.error(locs, msg, null);
    }

    public ErrorHandler getErrorHandler() {
        return this.controller;
    }

    protected final void error(Expression loc, String prop) {
        this.error(loc, prop, null);
    }

    protected final void error(Expression loc, String prop, Object arg1) {
        this.error(loc, prop, new Object[]{arg1});
    }

    protected final void error(Expression loc, String prop, Object[] args) {
        this.reportError(new Expression[]{loc}, Messages.format(prop, args));
    }

    protected final void error(Locator loc, String prop, Object arg1) {
        this.error(loc, prop, new Object[]{arg1});
    }

    protected final void error(Locator loc, String prop, Object[] args) {
        this.reportError(new Locator[]{loc}, Messages.format(prop, args));
    }

    private static void _assert(boolean b) {
        if (!b) {
            throw new InternalError("assertion failed");
        }
    }
}

