/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.annotator;

import com.sun.codemodel.JDefinedClass;
import com.sun.msv.grammar.Expression;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.BGMWalker;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.IgnoreItem;
import com.sun.tools.xjc.grammar.InterfaceItem;
import com.sun.tools.xjc.grammar.JavaItem;
import com.sun.tools.xjc.grammar.PrimitiveItem;
import com.sun.tools.xjc.grammar.SuperClassItem;
import com.sun.tools.xjc.grammar.TypeItem;
import com.sun.tools.xjc.grammar.WildcardItem;
import com.sun.tools.xjc.reader.annotator.AnnotatorController;
import com.sun.tools.xjc.reader.annotator.Messages;
import java.util.HashSet;
import java.util.Set;

public class HierarchyAnnotator {
    public static void annotate(AnnotatedGrammar grammar, final AnnotatorController controller) {
        BGMWalker annotator = new BGMWalker(){
            private JavaItem parent = null;
            private Set visitedExps = new HashSet();

            private void processChildren(JavaItem exp) {
                if (!this.visitedExps.add(exp)) {
                    return;
                }
                JavaItem old = this.parent;
                this.parent = exp;
                exp.exp.visit(this);
                this.parent = old;
            }

            public Object onClass(ClassItem ci) {
                if (this.parent instanceof SuperClassItem) {
                    this.setSuperClassBody((SuperClassItem)this.parent, ci);
                }
                if (this.parent instanceof InterfaceItem) {
                    this.setImplementedInterface(ci, (InterfaceItem)this.parent);
                }
                this.processChildren(ci);
                return null;
            }

            public Object onInterface(InterfaceItem ii) {
                if (this.parent instanceof InterfaceItem) {
                    this.setImplementedInterface(ii, (InterfaceItem)this.parent);
                }
                this.processChildren(ii);
                return null;
            }

            public Object onSuper(SuperClassItem si) {
                if (this.parent instanceof ClassItem) {
                    this.setSuperClassForClass((ClassItem)this.parent, si);
                }
                this.processChildren(si);
                return null;
            }

            public Object onField(FieldItem fi) {
                this.processChildren(fi);
                return null;
            }

            public Object onPrimitive(PrimitiveItem pi) {
                this.processChildren(pi);
                return null;
            }

            public Object onWildcard(WildcardItem wi) {
                this.processChildren(wi);
                return null;
            }

            public Object onIgnore(IgnoreItem ii) {
                return null;
            }

            protected void setImplementedInterface(TypeItem c, InterfaceItem i) {
                ((JDefinedClass)c.getType())._implements(i.getTypeAsClass());
            }

            protected void setSuperClassForClass(ClassItem p, SuperClassItem c) {
                if (p.superClass != null) {
                    controller.reportError(new Expression[]{p, p.superClass, c}, Messages.format("Normalizer.MultipleInheritance", new Object[]{p.name}));
                    return;
                }
                p.superClass = c;
            }

            protected void setSuperClassBody(SuperClassItem parent, ClassItem child) {
                if (parent.definition != null) {
                    controller.reportError(new Expression[]{parent, child, parent.definition}, Messages.format("Normalizer.MultipleSuperClassBody"));
                    return;
                }
                parent.definition = child;
            }
        };
        ClassItem[] cs = grammar.getClasses();
        int i = 0;
        while (i < cs.length) {
            cs[i].visit(annotator);
            ++i;
        }
    }
}

