/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.annotator;

import com.sun.msv.datatype.xsd.EnumerationFacet;
import com.sun.msv.datatype.xsd.ListType;
import com.sun.msv.datatype.xsd.StringType;
import com.sun.msv.datatype.xsd.UnionType;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionCloner;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.tools.xjc.reader.annotator.Messages;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DatatypeSimplifier
extends ExpressionCloner {
    private final Set visitedExps = new HashSet();

    public DatatypeSimplifier(ExpressionPool pool) {
        super(pool);
    }

    public Expression onRef(ReferenceExp exp) {
        if (this.visitedExps.add(exp)) {
            exp.exp = exp.exp.visit(this);
        }
        return exp;
    }

    public Expression onOther(OtherExp exp) {
        if (this.visitedExps.add(exp)) {
            exp.exp = exp.exp.visit(this);
        }
        return exp;
    }

    public Expression onElement(ElementExp exp) {
        if (this.visitedExps.add(exp)) {
            exp.contentModel = exp.contentModel.visit(this);
        }
        return exp;
    }

    public Expression onAttribute(AttributeExp exp) {
        if (this.visitedExps.contains(exp)) {
            return exp;
        }
        Expression e = this.pool.createAttribute(exp.nameClass, exp.exp.visit(this));
        this.visitedExps.add(e);
        return e;
    }

    public Expression onAnyString() {
        return this.pool.createData(StringType.theInstance);
    }

    public Expression onData(DataExp exp) {
        if (!(exp.dt instanceof XSDatatype)) {
            return exp;
        }
        return this.processDatatype((XSDatatype)exp.dt, false);
    }

    private Expression processDatatype(XSDatatype dt, boolean inList) {
        EnumerationFacet ef = (EnumerationFacet)dt.getFacetObject("enumeration");
        if (ef != null) {
            return this.processEnumeration(dt, ef);
        }
        switch (dt.getVariety()) {
            case 1: {
                return this.pool.createData(dt);
            }
            case 3: {
                return this.processUnion(dt, inList);
            }
            case 2: {
                return this.processList(dt, inList);
            }
        }
        throw new Error();
    }

    private Expression processEnumeration(XSDatatype type, EnumerationFacet enums) {
        Expression exp = Expression.nullSet;
        Iterator itr = enums.values.iterator();
        while (itr.hasNext()) {
            Object v = itr.next();
            exp = this.pool.createChoice(exp, this.pool.createValue(type, null, v));
        }
        return exp;
    }

    /*
     * Unable to fully structure code
     */
    private Expression processUnion(XSDatatype dt, boolean inList) {
        if (dt.getFacetObject("enumeration") != null) {
            throw new Error(Messages.format("DatatypeSimplifier.EnumFacetUnsupported"));
        }
        if (dt.getFacetObject("pattern") == null) ** GOTO lbl7
        throw new Error(Messages.format("DatatypeSimplifier.PatternFacetUnsupported"));
lbl-1000:
        // 1 sources

        {
            if ((dt = dt.getBaseType()) != null) continue;
            throw new Error();
lbl7:
            // 2 sources

            ** while (!(dt instanceof UnionType))
        }
lbl8:
        // 1 sources

        ut = (UnionType)dt;
        exp = Expression.nullSet;
        i = 0;
        while (i < ut.memberTypes.length) {
            exp = this.pool.createChoice(exp, this.processDatatype(ut.memberTypes[i], inList));
            ++i;
        }
        return exp;
    }

    private Expression processList(XSDatatype dt, boolean inList) {
        if (dt.getFacetObject("enumeration") != null) {
            throw new Error(Messages.format("DatatypeSimplifier.EnumFacetUnsupported"));
        }
        if (dt.getFacetObject("pattern") != null) {
            throw new Error(Messages.format("DatatypeSimplifier.PatternFacetUnsupported"));
        }
        XSDatatype d = dt;
        while (!(d instanceof ListType)) {
            if ((d = d.getBaseType()) != null) continue;
            throw new Error();
        }
        ListType lt = (ListType)d;
        Expression item = this.processDatatype(lt.itemType, true);
        Expression exp = this.pool.createZeroOrMore(item);
        if (inList) {
            return exp;
        }
        return this.pool.createList(exp);
    }
}

