/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.grammar.util;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionCloner;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.trex.ElementPattern;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.JavaItem;
import com.sun.tools.xjc.grammar.SuperClassItem;
import java.util.HashSet;
import java.util.Set;

public class SuperClassBodyRemover
extends ExpressionCloner {
    private final Set visitedRefs = new HashSet();
    private ExpressionCloner remover;

    public static void remove(AnnotatedGrammar g) {
        SuperClassBodyRemover su = new SuperClassBodyRemover(g.getPool());
        ClassItem[] cls = g.getClasses();
        int i = 0;
        while (i < cls.length) {
            cls[i].exp = cls[i].exp.visit(su);
            ++i;
        }
    }

    public Expression onAttribute(AttributeExp exp) {
        return this.pool.createAttribute(exp.nameClass, exp.exp.visit(this));
    }

    public Expression onElement(ElementExp exp) {
        if (this.visitedRefs.add(exp)) {
            exp.contentModel = exp.contentModel;
        }
        return exp;
    }

    public Expression onRef(ReferenceExp exp) {
        if (this.visitedRefs.add(exp)) {
            exp.exp = exp.exp.visit(this);
        }
        return exp;
    }

    public Expression onOther(OtherExp exp) {
        if (exp instanceof SuperClassItem) {
            return exp.exp.visit(this.remover);
        }
        if (this.visitedRefs.add(exp)) {
            exp.exp = exp.exp.visit(this);
        }
        return exp;
    }

    private SuperClassBodyRemover(ExpressionPool pool) {
        super(pool);
        this.remover = new ExpressionCloner(pool){

            public Expression onRef(ReferenceExp exp) {
                return exp.exp.visit(this);
            }

            public Expression onOther(OtherExp exp) {
                if (exp instanceof ClassItem) {
                    return exp.exp;
                }
                if (exp instanceof JavaItem) {
                    throw new Error("internal error");
                }
                return exp.exp.visit(this);
            }

            public Expression onAttribute(AttributeExp exp) {
                return this.pool.createAttribute(exp.nameClass, exp.exp.visit(this));
            }

            public Expression onElement(ElementExp exp) {
                Expression body = exp.contentModel.visit(this);
                if (body == exp.contentModel) {
                    return exp;
                }
                return new ElementPattern(exp.getNameClass(), body);
            }
        };
    }
}

