/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.generator.unmarshaller.util;

import com.sun.tools.xjc.generator.unmarshaller.Alphabet;
import com.sun.tools.xjc.generator.unmarshaller.Automaton;
import com.sun.tools.xjc.generator.unmarshaller.State;
import com.sun.tools.xjc.generator.unmarshaller.Transition;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Iterator;

public class AutomatonToGraphViz {
    private static final PrintStream debug = null;

    private static String getStateName(Automaton a, State s) {
        return "\"s" + a.getStateNumber(s) + (s.isListState ? "*" : "") + '\"';
    }

    private static String getColor(Alphabet a) {
        if (a instanceof Alphabet.EnterElement) {
            return "0";
        }
        if (a instanceof Alphabet.EnterAttribute) {
            return "0.125";
        }
        if (a instanceof Alphabet.LeaveAttribute) {
            return "0.25";
        }
        if (a instanceof Alphabet.LeaveElement) {
            return "0.375";
        }
        if (a instanceof Alphabet.Child) {
            return "0.5";
        }
        if (a instanceof Alphabet.SuperClass) {
            return "0.625";
        }
        if (a instanceof Alphabet.Text) {
            return "0.75";
        }
        throw new InternalError();
    }

    public static void convert(Automaton a, File target) throws IOException, InterruptedException {
        String s;
        System.err.println("generating a graph to " + target.getPath());
        Process proc = Runtime.getRuntime().exec(new String[]{"dot", "-Tgif", "-o", target.getPath()});
        PrintWriter out = new PrintWriter(new BufferedOutputStream(proc.getOutputStream()));
        out.println("digraph G {");
        out.println("node [shape=\"circle\"];");
        Iterator itr = a.states();
        while (itr.hasNext()) {
            State s2 = (State)itr.next();
            if (s2.isFinalState) {
                out.println(AutomatonToGraphViz.getStateName(a, s2) + " [shape=\"doublecircle\"];");
            }
            Iterator jtr = s2.transitions();
            while (jtr.hasNext()) {
                Transition t = (Transition)jtr.next();
                String str = MessageFormat.format("{0} -> {1} [ label=\"{2}\",color=\"{3} 1 .5\",fontcolor=\"{3} 1 .3\" ];", AutomatonToGraphViz.getStateName(a, s2), AutomatonToGraphViz.getStateName(a, t.to), t.alphabet, AutomatonToGraphViz.getColor(t.alphabet));
                out.println(str);
                if (debug == null) continue;
                debug.println(str);
            }
        }
        out.println("}");
        out.flush();
        out.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        while ((s = in.readLine()) != null) {
            System.out.println(s);
        }
        in.close();
        proc.waitFor();
    }
}

