/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.generator.unmarshaller;

import com.sun.tools.xjc.generator.unmarshaller.Alphabet;
import com.sun.tools.xjc.generator.unmarshaller.Automaton;
import com.sun.tools.xjc.generator.unmarshaller.State;
import com.sun.tools.xjc.generator.unmarshaller.Transition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class TransitionTable {
    private final Map table = new HashMap();
    private final Map eeAction = new HashMap();

    TransitionTable(Automaton a) {
        Iterator itr = a.states();
        while (itr.hasNext()) {
            State state = (State)itr.next();
            Iterator jtr = state.transitions();
            while (jtr.hasNext()) {
                Transition t = (Transition)jtr.next();
                Set head = t.head();
                if (head.contains(Alphabet.EVERYTHING_ELSE)) {
                    this.addEverythingElse(state, t);
                    head.remove(Alphabet.EVERYTHING_ELSE);
                }
                Iterator ktr = head.iterator();
                while (ktr.hasNext()) {
                    this.add(state, (Alphabet)ktr.next(), t);
                }
            }
            if (!state.isFinalState) continue;
            this.addEverythingElse(state, Transition.REVERT_TO_PARENT);
        }
    }

    public void add(State s, Alphabet alphabet, Transition action) {
        HashMap<Alphabet, Transition> m = (HashMap<Alphabet, Transition>)this.table.get(s);
        if (m == null) {
            m = new HashMap<Alphabet, Transition>();
            this.table.put(s, m);
        }
        m.put(alphabet, action);
    }

    public void addEverythingElse(State s, Transition action) {
        this.eeAction.put(s, action);
    }

    public Transition getEverythingElse(State s) {
        return (Transition)this.eeAction.get(s);
    }

    public Iterator list(State s) {
        Map m = (Map)this.table.get(s);
        if (m == null) {
            return new Iterator(){

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    return null;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return m.entrySet().iterator();
    }
}

