/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.generator.field;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.generator.field.FieldRenderer;
import com.sun.tools.xjc.generator.field.FieldRendererFactory;
import com.sun.tools.xjc.generator.field.MethodGenHelper;
import com.sun.tools.xjc.generator.marshaller.FieldMarshallerGenerator;
import com.sun.tools.xjc.grammar.FieldUse;
import org.xml.sax.Locator;

public class IsSetFieldRenderer
implements FieldRenderer {
    private final Locator location;
    private final FieldRenderer core;
    private final FieldUse use;

    public static FieldRendererFactory createFactory(final FieldRendererFactory core, final Locator loc) {
        return new FieldRendererFactory(){

            public FieldRenderer create(FieldUse fu) {
                return new IsSetFieldRenderer(fu, core.create(fu), loc);
            }
        };
    }

    public IsSetFieldRenderer(FieldUse _use, FieldRenderer _core, Locator _loc) {
        this.use = _use;
        this.core = _core;
        this.location = _loc;
    }

    public void generate(JDefinedClass interfaceClass, JDefinedClass implementationClass) {
        this.core.generate(interfaceClass, implementationClass);
        MethodGenHelper helper = new MethodGenHelper(this.use.name);
        helper.setClasses(interfaceClass, implementationClass);
        JCodeModel codeModel = interfaceClass.owner();
        JExpression hasSetValue = this.core.hasSetValue();
        if (hasSetValue == null) {
            // empty if block
        }
        helper.declareMethod(codeModel.BOOLEAN, "isSet").body()._return(hasSetValue);
        this.core.unsetValues(helper.declareMethod(codeModel.VOID, "unset").body());
    }

    public JBlock getOnSetEventHandler() {
        return this.core.getOnSetEventHandler();
    }

    public void unsetValues(JBlock body) {
        this.core.unsetValues(body);
    }

    public JExpression hasSetValue() {
        return this.core.hasSetValue();
    }

    public JExpression getValue() {
        return this.core.getValue();
    }

    public JType getValueType() {
        return this.core.getValueType();
    }

    public FieldUse getFieldUse() {
        return this.core.getFieldUse();
    }

    public void setter(JBlock body, JExpression newValue) {
        this.core.setter(body, newValue);
    }

    public JExpression ifCountEqual(int i) {
        return this.core.ifCountEqual(i);
    }

    public JExpression ifCountGte(int i) {
        return this.core.ifCountGte(i);
    }

    public JExpression ifCountLte(int i) {
        return this.core.ifCountLte(i);
    }

    public FieldMarshallerGenerator createMarshaller(JBlock block, String uniqueId) {
        return this.core.createMarshaller(block, uniqueId);
    }
}

