/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.writer;

import com.sun.codemodel.JPackage;
import com.sun.codemodel.writer.FileCodeWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FileWithPrologCodeWriter
extends FileCodeWriter {
    private final String prolog;
    private final boolean readOnly;
    private final Set files = new HashSet();

    public FileWithPrologCodeWriter(File target, String prolog, boolean readOnly) throws IOException {
        super(target);
        this.prolog = prolog;
        this.readOnly = readOnly;
    }

    protected File getFile(JPackage pkg, String fileName) throws IOException {
        File f = super.getFile(pkg, fileName);
        this.files.add(f);
        return f;
    }

    /*
     * WARNING - void declaration
     */
    public OutputStream open(JPackage pkg, String fileName) throws IOException {
        OutputStream fos = super.open(pkg, fileName);
        if (this.prolog != null && fileName.endsWith(".java")) {
            int idx;
            fos.write("//\n".getBytes());
            String s = this.prolog;
            while ((idx = s.indexOf(10)) != -1) {
                void var5_5;
                fos.write(("// " + s.substring(0, (int)var5_5) + "\n").getBytes());
                s = s.substring((int)(var5_5 + true));
            }
            fos.write("//\n\n".getBytes());
        }
        return fos;
    }

    public void close() throws IOException {
        super.close();
        if (this.readOnly) {
            Iterator itr = this.files.iterator();
            while (itr.hasNext()) {
                File f = (File)itr.next();
                f.setReadOnly();
            }
        }
    }
}

