/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.writer;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JPackage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileCodeWriter
implements CodeWriter {
    private final File target;

    public FileCodeWriter(File target) throws IOException {
        this.target = target;
        if (!target.exists() || !target.isDirectory()) {
            throw new IOException(target + ": non-existent directory");
        }
    }

    public OutputStream open(JPackage pkg, String fileName) throws IOException {
        return new FileOutputStream(this.getFile(pkg, fileName));
    }

    protected File getFile(JPackage pkg, String fileName) throws IOException {
        File fn;
        File dir = pkg.isUnnamed() ? this.target : new File(this.target, this.toDirName(pkg));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((fn = new File(dir, fileName)).exists() && !fn.delete()) {
            throw new IOException(fn + ": Can't delete previous version");
        }
        return fn;
    }

    public void close() throws IOException {
    }

    private String toDirName(JPackage pkg) {
        return pkg.name().replace('.', File.separatorChar);
    }
}

