/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDeclaration;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JMods;
import com.sun.codemodel.JNestedClass;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public abstract class JDefinedClass
extends JClass
implements JDeclaration,
JClassContainer {
    private String name = null;
    private final boolean isInterface;
    private JMods mods;
    private JClass superClass;
    private List interfaces = new ArrayList();
    private List fields = new ArrayList();
    private JBlock init = null;
    private JDocComment jdoc = null;
    private List constructors = new ArrayList();
    private List methods = new ArrayList();
    private final TreeMap classes = new TreeMap();
    private boolean hideFile = false;
    public Object metadata;
    static /* synthetic */ Class class$java$lang$Object;

    JDefinedClass(int mods, String name, boolean isInterface, JCodeModel owner) {
        super(owner);
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("JClass name empty");
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            String msg = "JClass name " + name + " contains illegal character" + " for beginning of identifier: " + name.charAt(0);
            throw new IllegalArgumentException(msg);
        }
        int i = 1;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                String msg = "JClass name " + name + " contains illegal character " + name.charAt(i);
                throw new IllegalArgumentException(msg);
            }
            ++i;
        }
        this.mods = isInterface ? JMods.forInterface(mods) : JMods.forClass(mods);
        this.name = name;
        this.isInterface = isInterface;
        if (!isInterface) {
            this.superClass = this.owner().ref(class$java$lang$Object == null ? (class$java$lang$Object = JDefinedClass.class$("java.lang.Object")) : class$java$lang$Object);
        }
    }

    public JDefinedClass _extends(JClass superClass2) {
        if (this.isInterface()) {
            throw new IllegalArgumentException("unable to set the super class for an interface");
        }
        if (superClass2 == null) {
            throw new NullPointerException();
        }
        this.superClass = superClass2;
        return this;
    }

    public JClass _extends() {
        return this.superClass;
    }

    public JDefinedClass _implements(JClass iface) {
        this.interfaces.add(iface);
        return this;
    }

    public Iterator _implements() {
        return this.interfaces.iterator();
    }

    public String name() {
        return this.name;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public abstract JClass _import(JPackage var1, String var2);

    public abstract JClass _import(String var1, String var2);

    public JFieldVar field(int mods, JType type, String name) {
        JFieldVar f = new JFieldVar(JMods.forField(mods), type, name, null);
        this.fields.add(f);
        return f;
    }

    public JFieldVar field(int mods, JType type, String name, JExpression init) {
        JFieldVar f = new JFieldVar(JMods.forField(mods), type, name, init);
        this.fields.add(f);
        return f;
    }

    public Iterator fields() {
        return this.fields.iterator();
    }

    public JBlock init() {
        if (this.init == null) {
            this.init = new JBlock();
        }
        return this.init;
    }

    public JMethod constructor(int mods) {
        JMethod c = new JMethod(mods, this);
        this.constructors.add(c);
        return c;
    }

    public Iterator constructors() {
        return this.constructors.iterator();
    }

    public JMethod method(int mods, JType type, String name) {
        JMethod m = new JMethod(this, mods, type, name);
        this.methods.add(m);
        return m;
    }

    public Iterator methods() {
        return this.methods.iterator();
    }

    public JDefinedClass _class(int mods, String name) throws JClassAlreadyExistsException {
        return this._class(mods, name, false);
    }

    public JDefinedClass _class(int mods, String name, boolean isInterface) throws JClassAlreadyExistsException {
        if (this.classes.containsKey(name)) {
            throw new JClassAlreadyExistsException((JDefinedClass)this.classes.get(name));
        }
        JNestedClass c = new JNestedClass(this, mods, name, isInterface);
        this.classes.put(name, c);
        return c;
    }

    public JDefinedClass _class(String name) throws JClassAlreadyExistsException {
        return this._class(1, name);
    }

    public JDefinedClass _interface(int mods, String name) throws JClassAlreadyExistsException {
        return this._class(mods, name, true);
    }

    public JDefinedClass _interface(String name) throws JClassAlreadyExistsException {
        return this._interface(1, name);
    }

    public JDocComment javadoc() {
        if (this.jdoc == null) {
            this.jdoc = new JDocComment();
        }
        return this.jdoc;
    }

    public void hide() {
        this.hideFile = true;
    }

    public boolean isHidden() {
        return this.hideFile;
    }

    public Iterator classes() {
        return this.classes.values().iterator();
    }

    public JClass outer() {
        return null;
    }

    public void declare(JFormatter f) {
        if (this.jdoc != null) {
            f.nl().g(this.jdoc);
        }
        f.g(this.mods).p(this.isInterface ? "interface" : "class").p(this.name);
        if (this.superClass != null && this.superClass != this.owner().ref(class$java$lang$Object == null ? (class$java$lang$Object = JDefinedClass.class$("java.lang.Object")) : class$java$lang$Object)) {
            f.nl().i().p("extends").g(this.superClass).nl().o();
        }
        if (!this.interfaces.isEmpty()) {
            boolean first = true;
            if (this.superClass == null) {
                f.nl();
            }
            f.i().p(this.isInterface ? "extends" : "implements");
            Iterator i = this.interfaces.iterator();
            while (i.hasNext()) {
                if (!first) {
                    f.p(',');
                }
                f.g((JClass)i.next());
                first = false;
            }
            f.nl().o();
        }
        this.declareBody(f);
    }

    protected void declareBody(JFormatter f) {
        f.p('{').nl().nl().i();
        Iterator i = this.fields.iterator();
        while (i.hasNext()) {
            f.d((JVar)i.next());
        }
        if (this.init != null) {
            f.nl().p("static").s(this.init);
        }
        Iterator i2 = this.constructors.iterator();
        while (i2.hasNext()) {
            f.nl().d((JMethod)i2.next());
        }
        Iterator i3 = this.methods.iterator();
        while (i3.hasNext()) {
            f.nl().d((JMethod)i3.next());
        }
        Iterator i4 = this.classes.values().iterator();
        while (i4.hasNext()) {
            f.nl().d((JDefinedClass)i4.next());
        }
        f.nl().o().p('}').nl();
    }

    public void generate(JFormatter f) {
        f.p(this.fullName());
    }

    public abstract JClassContainer parentContainer();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

