/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import net.sourceforge.jtds.test.DatabaseTestCase;
import net.sourceforge.jtds.util.Logger;

public class SAfeTest
extends DatabaseTestCase {
    volatile int started;
    volatile int done;
    static /* synthetic */ Class class$net$sourceforge$jtds$test$SAfeTest;

    public SAfeTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        Logger.setActive(true);
        if (stringArray.length > 0) {
            TestSuite testSuite = new TestSuite();
            int n = 0;
            while (n < stringArray.length) {
                testSuite.addTest((Test)new SAfeTest(stringArray[n]));
                ++n;
            }
            TestRunner.run((Test)testSuite);
        } else {
            TestRunner.run((Class)(class$net$sourceforge$jtds$test$SAfeTest == null ? (class$net$sourceforge$jtds$test$SAfeTest = SAfeTest.class$("net.sourceforge.jtds.test.SAfeTest")) : class$net$sourceforge$jtds$test$SAfeTest));
        }
    }

    public void testNullLengthStrings0001() throws Exception {
        String[] stringArray = new String[]{"VARCHAR(50)", "TEXT", "VARCHAR(350)", "NVARCHAR(50)", "NTEXT"};
        String[] stringArray2 = new String[]{null, "", " ", "x"};
        Statement statement = this.con.createStatement();
        boolean bl = this.props.getProperty("TDS") == null || this.props.getProperty("TDS").charAt(0) >= '7';
        int n = bl ? stringArray.length : 2;
        int n2 = 0;
        while (n2 < n) {
            Assert.assertTrue((statement.executeUpdate("CREATE TABLE #SAfe0001 (val " + stringArray[n2] + " NULL)") == 0 ? 1 : 0) != 0);
            int n3 = 0;
            while (n3 < stringArray2.length) {
                String string = stringArray2[n3] == null ? "INSERT INTO #SAfe0001 VALUES (NULL)" : "INSERT INTO #SAfe0001 VALUES ('" + stringArray2[n3] + "')";
                Assert.assertTrue((statement.executeUpdate(string) == 1 ? 1 : 0) != 0);
                ResultSet resultSet = statement.executeQuery("SELECT val FROM #SAfe0001");
                Assert.assertTrue((boolean)resultSet.next());
                if (bl || !" ".equals(stringArray2[n3])) {
                    Assert.assertEquals((Object)stringArray2[n3], (Object)resultSet.getString(1));
                } else {
                    Assert.assertEquals((Object)"", (Object)resultSet.getObject(1));
                }
                Assert.assertTrue((!resultSet.next() ? 1 : 0) != 0);
                Assert.assertTrue((statement.executeUpdate("TRUNCATE TABLE #SAfe0001") == 0 ? 1 : 0) != 0);
                ++n3;
            }
            Assert.assertTrue((statement.executeUpdate("DROP TABLE #SAfe0001") == 0 ? 1 : 0) != 0);
            ++n2;
        }
    }

    public void testCancel0002() throws Exception {
        Connection connection = this.getConnection();
        Logger.setActive(true);
        Statement statement = this.con.createStatement();
        Assert.assertTrue((!statement.execute("create table ##SAfe0002 (id int primary key, val varchar(20) null) insert into ##SAfe0002 values (1, 'Line 1') insert into ##SAfe0002 values (2, 'Line 2')") ? 1 : 0) != 0);
        Assert.assertEquals((int)0, (int)statement.getUpdateCount());
        Assert.assertTrue((!statement.getMoreResults() ? 1 : 0) != 0);
        Assert.assertEquals((int)1, (int)statement.getUpdateCount());
        Assert.assertTrue((!statement.getMoreResults() ? 1 : 0) != 0);
        Assert.assertEquals((int)1, (int)statement.getUpdateCount());
        Assert.assertTrue((!statement.getMoreResults() ? 1 : 0) != 0);
        Assert.assertEquals((int)-1, (int)statement.getUpdateCount());
        this.con.setAutoCommit(false);
        statement.executeUpdate("update ##SAfe0002 set val='Updated Line' where id=1");
        Statement statement2 = connection.createStatement();
        statement2.setQueryTimeout(1);
        try {
            statement2.executeQuery("select * from ##SAfe0002");
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.con.commit();
        this.con.setAutoCommit(true);
        statement.execute("drop table ##SAfe0002");
        statement.close();
        ResultSet resultSet = statement2.executeQuery("select 1");
        Assert.assertTrue((boolean)resultSet.next());
        Assert.assertEquals((int)1, (int)resultSet.getInt(1));
        Assert.assertTrue((!resultSet.next() ? 1 : 0) != 0);
        connection.close();
    }

    public void testCursorResultSetConcurrency0003() throws Exception {
        Object object;
        Object object2;
        Statement statement = this.con.createStatement();
        statement.execute("create table #SAfe0003(id int primary key, val varchar(20) null) insert into #SAfe0003 values (1, 'Line 1') insert into #SAfe0003 values (2, 'Line 2')");
        while (statement.getMoreResults() || statement.getUpdateCount() != -1) {
        }
        final Object object3 = new Object();
        final Object object4 = new Object();
        final Statement statement2 = this.con.createStatement(1004, 1007);
        int n = 25;
        Thread[] threadArray = new Thread[n];
        this.done = 0;
        this.started = 0;
        int n2 = 0;
        while (n2 < n) {
            threadArray[n2] = new Thread(){

                /*
                 * Unable to fully structure code
                 */
                public void run() {
                    block22: {
                        var1_1 = null;
                        try {
                            var1_1 = statement2.executeQuery("SELECT * FROM #SAfe0003");
                            var2_2 = object4;
                            synchronized (var2_2) {
                                var3_4 = object3;
                                synchronized (var3_4) {
                                    ++SAfeTest.this.started;
                                    object3.notify();
                                }
                                try {
                                    object4.wait();
                                }
                                catch (InterruptedException var4_6) {
                                    // empty catch block
                                }
                            }
                            Assert.assertNotNull((String)"executeQuery should not return null", (Object)var1_1);
                            Assert.assertTrue((boolean)var1_1.next());
                            Assert.assertTrue((boolean)var1_1.next());
                            Assert.assertTrue((boolean)(var1_1.next() == false));
                            Assert.assertTrue((boolean)var1_1.previous());
                            Assert.assertTrue((boolean)var1_1.previous());
                            Assert.assertTrue((boolean)(var1_1.previous() == false));
                            var7_8 = null;
                            ** if (var1_1 == null) goto lbl-1000
                        }
                        catch (Throwable var6_14) {
                            var7_10 = null;
                            if (var1_1 != null) {
                                try {
                                    var1_1.close();
                                }
                                catch (SQLException var8_13) {
                                    // empty catch block
                                }
                            }
                            throw var6_14;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                var1_1.close();
                            }
                            catch (SQLException var8_11) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block22;
                            catch (SQLException var2_3) {
                                var2_3.printStackTrace();
                                Assert.fail((String)("An SQL Exception occured: " + var2_3));
                                var7_9 = null;
                                if (var1_1 != null) {
                                    try {
                                        var1_1.close();
                                    }
                                    catch (SQLException var8_12) {}
                                }
                            }
                        }
                    }
                    var2_2 = object3;
                    synchronized (var2_2) {
                        ++SAfeTest.this.done;
                        object3.notify();
                    }
                }
            };
            threadArray[n2].start();
            ++n2;
        }
        while (true) {
            object2 = object3;
            synchronized (object2) {
                if (this.started == n) {
                    break;
                }
                object3.wait();
            }
        }
        object2 = object4;
        synchronized (object2) {
            object4.notifyAll();
        }
        boolean bl = true;
        int n3 = 0;
        while (n3 < n) {
            statement = this.con.createStatement();
            object = statement.executeQuery("SELECT 1234");
            bl &= object.next();
            bl &= !object.next();
            statement.close();
            ++n3;
        }
        while (true) {
            object = object3;
            synchronized (object) {
                if (this.done == n) {
                    break;
                }
                object3.wait();
            }
        }
        int n4 = 0;
        while (n4 < n) {
            threadArray[n4].join();
            ++n4;
        }
        statement.close();
        statement2.close();
        Assert.assertTrue((boolean)bl);
    }

    public void testCursorResultSetEmpty0004() throws Exception {
        Statement statement = this.con.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery("SELECT 5 Value WHERE 1=0");
        Assert.assertEquals((Object)"Value", (Object)resultSet.getMetaData().getColumnName(1));
        resultSet.close();
        statement.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

