/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.sql.Timestamp;
import net.sourceforge.jtds.jdbc.TdsDefinitions;
import net.sourceforge.jtds.jdbc.TdsException;
import net.sourceforge.jtds.jdbc.TdsUnknownPacketType;
import net.sourceforge.jtds.util.HexDump;
import net.sourceforge.jtds.util.Logger;

public class TdsComm
implements TdsDefinitions {
    private DataOutputStream out = null;
    private DataInputStream in = null;
    byte[] outBuffer;
    int outBufferLen;
    int nextOutBufferIndex = 0;
    int packetType = 0;
    byte[] inBuffer;
    int inBufferIndex = 0;
    int inBufferLen = 0;
    int packetsSent = 0;
    int packetsReceived = 0;
    private int tdsVer = 42;
    byte[] tmpBuf = new byte[8];
    byte[] resBuffer = new byte[256];
    public static final String cvsVersion = "$Id: TdsComm.java,v 1.1 2002/10/14 10:48:59 alin_sinpalean Exp $";
    static final int headerLength = 8;
    public static final byte QUERY = 1;
    public static final byte LOGON = 2;
    public static final byte PROC = 3;
    public static final byte REPLY = 4;
    public static final byte CANCEL = 6;
    public static final byte LOGON70 = 16;
    private static final int maxPacketLength = 512;
    private static int nextId = 0;
    private int id;

    public TdsComm(Socket socket, int n) throws IOException {
        this.out = new DataOutputStream(socket.getOutputStream());
        this.in = new DataInputStream(socket.getInputStream());
        this.outBufferLen = 512;
        this.outBuffer = new byte[this.outBufferLen];
        this.inBuffer = new byte[512];
        this.tdsVer = n;
        this.id = ++nextId;
    }

    public void close() {
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void startPacket(int var1_1) throws TdsException {
        if (var1_1 == 6 || this.inBufferIndex == this.inBufferLen) ** GOTO lbl11
        this.inBufferIndex = this.inBufferLen;
        if (Logger.isActive()) {
            Logger.println("Unprocessed data in input buffer. Dumping. [" + this.inBufferIndex + "/" + this.inBufferLen + "]");
        }
        throw new TdsException("Unprocessed data in input buffer.");
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException var2_2) {
                // empty catch block
            }
lbl11:
            // 3 sources

            ** while (this.someThreadIsBuildingPacket())
        }
lbl12:
        // 1 sources

        this.packetType = var1_1;
        this.nextOutBufferIndex = 8;
    }

    public boolean someThreadIsBuildingPacket() {
        return this.packetType != 0;
    }

    public void appendByte(byte by) throws IOException {
        if (this.nextOutBufferIndex == this.outBufferLen) {
            this.sendPhysicalPacket(false);
            this.nextOutBufferIndex = 8;
        }
        this.storeByte(this.nextOutBufferIndex, by);
        ++this.nextOutBufferIndex;
    }

    public void appendBytes(byte[] byArray) throws IOException {
        this.appendBytes(byArray, byArray.length, (byte)0);
    }

    public void appendBytes(byte[] byArray, int n, byte by) throws IOException {
        int n2 = 0;
        while (n2 < byArray.length && n2 < n) {
            this.appendByte(byArray[n2]);
            ++n2;
        }
        while (n2 < n) {
            this.appendByte(by);
            ++n2;
        }
    }

    public void appendShort(short s) throws IOException {
        this.appendByte((byte)(s >> 8 & 0xFF));
        this.appendByte((byte)(s >> 0 & 0xFF));
    }

    public void appendTdsShort(short s) throws IOException {
        this.appendByte((byte)(s >> 0 & 0xFF));
        this.appendByte((byte)(s >> 8 & 0xFF));
    }

    public void appendFlt8(Double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        this.appendByte((byte)(l >> 0 & 0xFFL));
        this.appendByte((byte)(l >> 8 & 0xFFL));
        this.appendByte((byte)(l >> 16 & 0xFFL));
        this.appendByte((byte)(l >> 24 & 0xFFL));
        this.appendByte((byte)(l >> 32 & 0xFFL));
        this.appendByte((byte)(l >> 40 & 0xFFL));
        this.appendByte((byte)(l >> 48 & 0xFFL));
        this.appendByte((byte)(l >> 56 & 0xFFL));
    }

    public void appendInt(int n) throws IOException {
        this.appendByte((byte)(n >> 24 & 0xFF));
        this.appendByte((byte)(n >> 16 & 0xFF));
        this.appendByte((byte)(n >> 8 & 0xFF));
        this.appendByte((byte)(n >> 0 & 0xFF));
    }

    public void appendTdsInt(int n) throws IOException {
        this.appendByte((byte)(n >> 0 & 0xFF));
        this.appendByte((byte)(n >> 8 & 0xFF));
        this.appendByte((byte)(n >> 16 & 0xFF));
        this.appendByte((byte)(n >> 24 & 0xFF));
    }

    public void appendInt64(long l) throws IOException {
        this.appendByte((byte)(l >> 56 & 0xFFL));
        this.appendByte((byte)(l >> 48 & 0xFFL));
        this.appendByte((byte)(l >> 40 & 0xFFL));
        this.appendByte((byte)(l >> 32 & 0xFFL));
        this.appendByte((byte)(l >> 24 & 0xFFL));
        this.appendByte((byte)(l >> 16 & 0xFFL));
        this.appendByte((byte)(l >> 8 & 0xFFL));
        this.appendByte((byte)(l >> 0 & 0xFFL));
    }

    public void appendChars(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            byte by = (byte)(c & 0xFF);
            byte by2 = (byte)(c >> 8 & 0xFF);
            this.appendByte(by);
            this.appendByte(by2);
            ++n;
        }
    }

    public synchronized void sendPacket() throws IOException {
        this.sendPhysicalPacket(true);
        this.nextOutBufferIndex = 0;
        this.packetType = 0;
        this.notify();
    }

    private void storeByte(int n, byte by) {
        this.outBuffer[n] = by;
    }

    private void storeShort(int n, short s) {
        this.outBuffer[n] = (byte)(s >> 8 & 0xFF);
        this.outBuffer[n + 1] = (byte)(s >> 0 & 0xFF);
    }

    private void sendPhysicalPacket(boolean bl) throws IOException {
        if (this.nextOutBufferIndex > 8 || this.packetType == 6) {
            this.storeByte(0, (byte)(this.packetType & 0xFF));
            this.storeByte(1, bl ? (byte)1 : 0);
            this.storeShort(2, (short)this.nextOutBufferIndex);
            this.storeByte(4, (byte)0);
            this.storeByte(5, (byte)0);
            this.storeByte(6, this.tdsVer == 70 ? (byte)1 : 0);
            this.storeByte(7, (byte)0);
            this.out.write(this.outBuffer, 0, this.nextOutBufferIndex);
            ++this.packetsSent;
            if (Logger.isActive()) {
                String string = HexDump.hexDump(this.outBuffer, this.nextOutBufferIndex);
                String string2 = new Timestamp(System.currentTimeMillis()).toString();
                Logger.println("Instance " + this.id + " @ " + string2 + " sent packet #" + this.packetsSent + "\n" + string);
            }
        }
    }

    public byte peek() throws TdsException, IOException {
        if (this.inBufferIndex >= this.inBufferLen) {
            this.getPhysicalPacket();
        }
        return this.inBuffer[this.inBufferIndex];
    }

    public byte getByte() throws TdsException, IOException {
        if (this.inBufferIndex >= this.inBufferLen) {
            this.getPhysicalPacket();
        }
        byte by = this.inBuffer[this.inBufferIndex++];
        return by;
    }

    public byte[] getBytes(int n, boolean bl) throws TdsException, IOException {
        byte[] byArray = null;
        if (bl || n > 16384) {
            byArray = new byte[n];
        } else {
            if (this.resBuffer.length < n) {
                this.resBuffer = new byte[n];
            }
            byArray = this.resBuffer;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if (this.inBufferIndex >= this.inBufferLen) {
                this.getPhysicalPacket();
            }
            n3 = (n3 = this.inBufferLen - this.inBufferIndex) > n - n2 ? n - n2 : n3;
            System.arraycopy(this.inBuffer, this.inBufferIndex, byArray, n2, n3);
            n2 += n3;
            this.inBufferIndex += n3;
        }
        return byArray;
    }

    public String getString(int n) throws TdsException, IOException {
        if (this.tdsVer == 70) {
            char[] cArray = new char[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.getByte() & 0xFF;
                int n4 = this.getByte() & 0xFF;
                cArray[n2] = (char)(n3 | n4 << 8);
                ++n2;
            }
            return new String(cArray);
        }
        return new String(this.getBytes(n, false), 0, n);
    }

    public void skip(int n) throws TdsException, IOException {
        while (n > 0) {
            this.getByte();
            --n;
        }
    }

    public int getNetShort() throws TdsException, IOException {
        byte[] byArray = new byte[]{this.getByte(), this.getByte()};
        return TdsComm.ntohs(byArray, 0);
    }

    public int getTdsShort() throws TdsException, IOException {
        int n = this.getByte() & 0xFF;
        int n2 = (this.getByte() & 0xFF) << 8;
        return n | n2;
    }

    public int getTdsInt() throws TdsException, IOException {
        int n = this.getByte() & 0xFF;
        int n2 = (this.getByte() & 0xFF) << 8;
        int n3 = (this.getByte() & 0xFF) << 16;
        int n4 = (this.getByte() & 0xFF) << 24;
        int n5 = n4 | n3 | n2 | n;
        return n5;
    }

    public long getTdsInt64() throws TdsException, IOException {
        long l = (long)this.getByte() & 0xFFL;
        long l2 = ((long)this.getByte() & 0xFFL) << 8;
        long l3 = ((long)this.getByte() & 0xFFL) << 16;
        long l4 = ((long)this.getByte() & 0xFFL) << 24;
        long l5 = ((long)this.getByte() & 0xFFL) << 32;
        long l6 = ((long)this.getByte() & 0xFFL) << 40;
        long l7 = ((long)this.getByte() & 0xFFL) << 48;
        long l8 = ((long)this.getByte() & 0xFFL) << 56;
        return l | l2 | l3 | l4 | l5 | l6 | l7 | l8;
    }

    private void getPhysicalPacket() throws TdsException, IOException {
        byte by;
        int n = 0;
        while (n < 8) {
            n += this.in.read(this.tmpBuf, n, 8 - n);
        }
        if (Logger.isActive()) {
            String string = HexDump.hexDump(this.tmpBuf, 8);
            String string2 = new Timestamp(System.currentTimeMillis()).toString();
            Logger.println("Instance " + this.id + " @ " + string2 + " received header #" + (this.packetsReceived + 1) + "\n" + string);
        }
        if ((by = this.tmpBuf[0]) != 2 && by != 1 && by != 4) {
            throw new TdsUnknownPacketType(by, this.tmpBuf);
        }
        int n2 = TdsComm.ntohs(this.tmpBuf, 2) - 8;
        if (n2 >= this.inBuffer.length) {
            this.inBuffer = new byte[n2];
        }
        if (n2 < 0) {
            throw new TdsException("Confused by a length of " + n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            n3 += this.in.read(this.inBuffer, n3, n2 - n3);
        }
        ++this.packetsReceived;
        this.inBufferLen = n2;
        this.inBufferIndex = 0;
        if (Logger.isActive()) {
            String string = HexDump.hexDump(this.inBuffer, n2);
            String string3 = new Timestamp(System.currentTimeMillis()).toString();
            Logger.println("Instance " + this.id + " @ " + string3 + " received data #" + this.packetsReceived + "\n" + string);
        }
    }

    void resizeOutbuf(int n) {
        if (n > this.outBufferLen) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.outBuffer, 0, byArray, 0, this.outBufferLen);
            this.outBufferLen = n;
            this.outBuffer = byArray;
        }
    }

    private static int ntohs(byte[] byArray, int n) {
        int n2 = byArray[n + 1] & 0xFF;
        int n3 = (byArray[n] & 0xFF) << 8;
        return n3 | n2;
    }
}

