/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import net.sourceforge.jtds.jdbc.PacketErrorResult;
import net.sourceforge.jtds.jdbc.PacketMsgResult;

class SQLWarningChain {
    public static final String cvsVersion = "$Id: SQLWarningChain.java,v 1.1 2002/10/14 10:48:59 alin_sinpalean Exp $";
    private SQLWarning warnings = null;
    private SQLException exceptions;

    SQLWarningChain() {
    }

    synchronized SQLWarning getWarnings() {
        return this.warnings;
    }

    synchronized SQLException getExceptions() {
        return this.exceptions;
    }

    synchronized void checkForExceptions() throws SQLException {
        if (this.exceptions != null) {
            SQLException sQLException = this.exceptions;
            this.exceptions = null;
            throw sQLException;
        }
    }

    synchronized void clearWarnings() {
        this.warnings = null;
        this.exceptions = null;
    }

    synchronized void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    synchronized void addException(SQLException sQLException) {
        if (this.exceptions == null) {
            this.exceptions = sQLException;
        } else {
            this.exceptions.setNextException(sQLException);
        }
    }

    SQLException addOrReturn(PacketMsgResult packetMsgResult) {
        if (packetMsgResult instanceof PacketErrorResult) {
            SQLException sQLException = packetMsgResult.getMsg().toSQLException();
            this.addException(sQLException);
            return sQLException;
        }
        this.addWarning(packetMsgResult.getMsg().toSQLWarning());
        return null;
    }
}

