/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import net.sourceforge.jtds.jdbc.AbstractResultSet;
import net.sourceforge.jtds.jdbc.Columns;
import net.sourceforge.jtds.jdbc.Context;
import net.sourceforge.jtds.jdbc.DriverVersion;
import net.sourceforge.jtds.jdbc.Microsoft7MetaData;
import net.sourceforge.jtds.jdbc.PacketRowResult;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsConnection;
import net.sourceforge.jtds.jdbc.TdsResultSet;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    public static final String cvsVersion = "$Id: DatabaseMetaData.java,v 1.6 2003/01/27 09:24:37 alin_sinpalean Exp $";
    Tds tds;
    TdsConnection connection;
    int sysnameLength = 30;
    Boolean caseSensitive = null;

    public DatabaseMetaData(TdsConnection tdsConnection, Tds tds) throws SQLException {
        this.connection = tdsConnection;
        this.tds = tds;
    }

    public static DatabaseMetaData getInstance(TdsConnection tdsConnection, Tds tds) throws SQLException {
        if (tds.getTdsVer() >= 70) {
            return new Microsoft7MetaData(tdsConnection, tds);
        }
        return new DatabaseMetaData(tdsConnection, tds);
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        String string4 = "exec sp_special_columns ?, ?, ?, ?, ?, ?";
        if (string != null) {
            string4 = "exec " + string + "..sp_special_columns ?, ?, ?, ?, ?, ?";
        }
        CallableStatement callableStatement = this.connection.prepareCall(string4);
        callableStatement.setString(1, string3);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string);
        callableStatement.setString(4, "R");
        callableStatement.setString(5, "T");
        callableStatement.setString(6, "U");
        TdsResultSet tdsResultSet = (TdsResultSet)callableStatement.executeQuery();
        Columns columns = tdsResultSet.getContext().getColumnInfo();
        columns.setName(5, "COLUMN_SIZE");
        columns.setLabel(5, "COLUMN_SIZE");
        columns.setName(6, "BUFFER_LENGTH");
        columns.setLabel(6, "BUFFER_LENGTH");
        columns.setName(7, "DECIMAL_DIGITS");
        columns.setLabel(7, "DECIMAL_DIGITS");
        return tdsResultSet;
    }

    public ResultSet getCatalogs() throws SQLException {
        String string = "exec sp_tables '', '', '%', NULL";
        Statement statement = this.connection.createStatement();
        TdsResultSet tdsResultSet = (TdsResultSet)statement.executeQuery(string);
        Columns columns = tdsResultSet.getContext().getColumnInfo();
        columns.setFakeColumnCount(1);
        columns.setName(1, "TABLE_CAT");
        columns.setLabel(1, "TABLE_CAT");
        return tdsResultSet;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "exec sp_column_privileges ?, ?, ?, ?";
        if (string != null) {
            string5 = "exec " + string + "..sp_column_privileges ?, ?, ?, ?";
        }
        CallableStatement callableStatement = this.connection.prepareCall(string5);
        callableStatement.setString(1, string3);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string);
        callableStatement.setString(4, string4);
        TdsResultSet tdsResultSet = (TdsResultSet)callableStatement.executeQuery();
        Columns columns = tdsResultSet.getContext().getColumnInfo();
        columns.setName(1, "TABLE_CAT");
        columns.setLabel(1, "TABLE_CAT");
        columns.setName(2, "TABLE_SCHEM");
        columns.setLabel(2, "TABLE_SCHEM");
        return tdsResultSet;
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "exec sp_columns ?, ?, ?, ?, ?";
        if (string != null) {
            string5 = "exec " + string + "..sp_columns ?, ?, ?, ?, ?";
        }
        CallableStatement callableStatement = this.connection.prepareCall(string5);
        callableStatement.setString(1, string3);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string);
        callableStatement.setString(4, string4);
        callableStatement.setInt(5, 3);
        TdsResultSet tdsResultSet = (TdsResultSet)callableStatement.executeQuery();
        Columns columns = tdsResultSet.getContext().getColumnInfo();
        columns.setName(1, "TABLE_CAT");
        columns.setLabel(1, "TABLE_CAT");
        columns.setName(2, "TABLE_SCHEM");
        columns.setLabel(2, "TABLE_SCHEM");
        columns.setName(7, "COLUMN_SIZE");
        columns.setLabel(7, "COLUMN_SIZE");
        columns.setName(8, "BUFFER_LENGTH");
        columns.setLabel(8, "BUFFER_LENGTH");
        columns.setName(9, "DECIMAL_DIGITS");
        columns.setLabel(9, "DECIMAL_DIGITS");
        columns.setName(10, "NUM_PREC_RADIX");
        columns.setLabel(10, "NUM_PREC_RADIX");
        columns.setFakeColumnCount(18);
        return tdsResultSet;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        String string7 = "exec sp_fkeys ?, ?, ?, ?, ?, ?";
        if (string != null) {
            string7 = "exec " + string + "..sp_fkeys ?, ?, ?, ?, ?, ?";
        } else if (string4 != null) {
            string7 = "exec " + string4 + "..sp_fkeys ?, ?, ?, ?, ?, ?";
        }
        CallableStatement callableStatement = this.connection.prepareCall(string7);
        callableStatement.setString(1, string3);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string);
        callableStatement.setString(4, string6);
        callableStatement.setString(5, string5);
        callableStatement.setString(6, string4);
        TdsResultSet tdsResultSet = (TdsResultSet)callableStatement.executeQuery();
        Columns columns = tdsResultSet.getContext().getColumnInfo();
        columns.setName(1, "PKTABLE_CAT");
        columns.setLabel(1, "PKTABLE_CAT");
        columns.setName(2, "PKTABLE_SCHEM");
        columns.setLabel(2, "PKTABLE_SCHEM");
        columns.setName(5, "FKTABLE_CAT");
        columns.setLabel(5, "FKTABLE_CAT");
        columns.setName(6, "FKTABLE_SCHEM");
        columns.setLabel(6, "FKTABLE_SCHEM");
        return tdsResultSet;
    }

    public String getDatabaseProductName() throws SQLException {
        return this.tds.getDatabaseProductName();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.tds.getDatabaseProductVersion();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public int getDriverMajorVersion() {
        return DriverVersion.getDriverMajorVersion();
    }

    public int getDriverMinorVersion() {
        return DriverVersion.getDriverMinorVersion();
    }

    public String getDriverName() throws SQLException {
        return "jTDS Type 4 JDBC Driver for MS SQL Server";
    }

    public String getDriverVersion() throws SQLException {
        return this.getDriverMajorVersion() + "." + this.getDriverMinorVersion();
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getCrossReference(string, string2, string3, null, null, null);
    }

    public String getExtraNameCharacters() throws SQLException {
        return "#$";
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getCrossReference(null, null, null, string, string2, string3);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        String string4 = "exec sp_statistics ?, ?, ?, ?, ?, ?";
        if (string != null) {
            string4 = "exec " + string + "..sp_statistics ?, ?, ?, ?, ?, ?";
        }
        CallableStatement callableStatement = this.connection.prepareCall(string4);
        callableStatement.setString(1, string3);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string);
        callableStatement.setString(4, "%");
        callableStatement.setString(5, bl ? "Y" : "N");
        callableStatement.setString(6, bl2 ? "Q" : "E");
        TdsResultSet tdsResultSet = (TdsResultSet)callableStatement.executeQuery();
        Columns columns = tdsResultSet.getContext().getColumnInfo();
        columns.setName(1, "TABLE_CAT");
        columns.setLabel(1, "TABLE_CAT");
        columns.setName(2, "TABLE_SCHEM");
        columns.setLabel(2, "TABLE_SCHEM");
        columns.setName(8, "ORDINAL_POSITION");
        columns.setLabel(8, "ORDINAL_POSITION");
        columns.setName(10, "ASC_OR_DESC");
        columns.setLabel(10, "ASC_OR_DESC");
        return tdsResultSet;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 131072;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 131072;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 4000;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 250;
    }

    public int getMaxConnections() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxIndexLength() throws SQLException {
        return 900;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxRowSize() throws SQLException {
        return 1962;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxStatementLength() throws SQLException {
        return 131072;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 16;
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN";
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        String string4 = "exec sp_pkeys ?, ?, ?";
        if (string != null) {
            string4 = "exec " + string + "..sp_pkeys ?, ?, ?";
        }
        CallableStatement callableStatement = this.connection.prepareCall(string4);
        callableStatement.setString(1, string3);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string);
        TdsResultSet tdsResultSet = (TdsResultSet)callableStatement.executeQuery();
        Columns columns = tdsResultSet.getContext().getColumnInfo();
        columns.setName(1, "TABLE_CAT");
        columns.setLabel(1, "TABLE_CAT");
        columns.setName(2, "TABLE_SCHEM");
        columns.setLabel(2, "TABLE_SCHEM");
        return tdsResultSet;
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "exec sp_sproc_columns ?, ?, ?, ?, 3";
        if (string != null) {
            string5 = "exec " + string + "..sp_sproc_columns ?, ?, ?, ?, 3";
        }
        CallableStatement callableStatement = this.connection.prepareCall(string5);
        callableStatement.setString(1, string3);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string);
        callableStatement.setString(4, string4);
        TdsResultSet tdsResultSet = (TdsResultSet)callableStatement.executeQuery();
        Columns columns = tdsResultSet.getContext().getColumnInfo();
        columns.setName(1, "PROCEDURE_CAT");
        columns.setLabel(1, "PROCEDURE_CAT");
        columns.setName(2, "PROCEDURE_SCHEM");
        columns.setLabel(2, "PROCEDURE_SCHEM");
        return tdsResultSet;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        String string4 = "exec sp_stored_procedures ?, ?, ?";
        if (string != null) {
            string4 = "exec " + string + "..sp_stored_procedures ?, ?, ?";
        }
        CallableStatement callableStatement = this.connection.prepareCall(string4);
        callableStatement.setString(1, string3);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string);
        TdsResultSet tdsResultSet = (TdsResultSet)callableStatement.executeQuery();
        return tdsResultSet;
    }

    public String getProcedureTerm() throws SQLException {
        return "stored procedure";
    }

    public ResultSet getSchemas() throws SQLException {
        Statement statement = this.connection.createStatement();
        String string = "SELECT name AS TABLE_SCHEM FROM dbo.sysusers WHERE issqlrole=0";
        return statement.executeQuery(string);
    }

    public String getSchemaTerm() throws SQLException {
        return "owner";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getSQLKeywords() throws SQLException {
        return "BREAK,BROWSE,BULK,CHECKPOINT,CLUSTERED,COMMITTED,COMPUTE,CONFIRM,CONTROLROW,DATABASE,DBCC,DISK,DISTRIBUTED,DUMMY,DUMP,ERRLVL,ERROREXIT,EXIT,FILE,FILLFACTOR,FLOPPY,HOLDLOCK,IDENTITY_INSERT,IDENTITYCOL,IF,KILL,LINENO,LOAD,MIRROREXIT,NONCLUSTERED,OFF,OFFSETS,ONCE,OVER,PERCENT,PERM,PERMANENT,PLAN,PRINT,PROC,PROCESSEXIT,RAISERROR,READ,READTEXT,RECONFIGURE,REPEATABLE,RETURN,ROWCOUNT,RULE,SAVE,SERIALIZABLE,SETUSER,SHUTDOWN,STATISTICS,TAPE,TEMP,TEXTSIZE,TOP,TRAN,TRIGGER,TRUNCATE,TSEQUEL,UNCOMMITTED,UPDATETEXT,USE,WAITFOR,WHILE,WRITETEXT";
    }

    public String getStringFunctions() throws SQLException {
        return "ASCII,CHAR,DIFFERENCE,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTRING,UCASE";
    }

    public String getSystemFunctions() throws SQLException {
        return "DATABASE,IFNULL,USER";
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        String string4 = "exec sp_table_privileges ?, ?, ?";
        if (string != null) {
            string4 = "exec " + string + "..sp_table_privileges ?, ?, ?";
        }
        CallableStatement callableStatement = this.connection.prepareCall(string4);
        callableStatement.setString(1, string3);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string);
        TdsResultSet tdsResultSet = (TdsResultSet)callableStatement.executeQuery();
        Columns columns = tdsResultSet.getContext().getColumnInfo();
        columns.setName(1, "TABLE_CAT");
        columns.setLabel(1, "TABLE_CAT");
        columns.setName(2, "TABLE_SCHEM");
        columns.setLabel(2, "TABLE_SCHEM");
        return tdsResultSet;
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        Object object;
        String string4 = "exec sp_tables ?, ?, ?, ?";
        if (string != null) {
            string4 = "exec " + string + "..sp_tables ?, ?, ?, ?";
        }
        CallableStatement callableStatement = this.connection.prepareCall(string4);
        callableStatement.setString(1, string3);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string);
        if (stringArray == null) {
            callableStatement.setString(4, null);
        } else {
            object = new StringBuffer(64);
            ((StringBuffer)object).append('\"');
            int n = 0;
            while (n < stringArray.length) {
                ((StringBuffer)object).append('\'').append(stringArray[n]).append("',");
                ++n;
            }
            if (((StringBuffer)object).length() > 1) {
                ((StringBuffer)object).setLength(((StringBuffer)object).length() - 1);
            }
            ((StringBuffer)object).append('\"');
            callableStatement.setString(4, ((StringBuffer)object).toString());
        }
        object = (TdsResultSet)callableStatement.executeQuery();
        Columns columns = ((TdsResultSet)object).getContext().getColumnInfo();
        columns.setName(1, "TABLE_CAT");
        columns.setLabel(1, "TABLE_CAT");
        columns.setName(2, "TABLE_SCHEM");
        columns.setLabel(2, "TABLE_SCHEM");
        return object;
    }

    public ResultSet getTableTypes() throws SQLException {
        String string = "select 'TABLE' TABLE_TYPE              union select 'VIEW' TABLE_TYPE         union select 'SYSTEM TABLE' TABLE_TYPE ";
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        return resultSet;
    }

    public String getTimeDateFunctions() throws SQLException {
        return "GETDATE,DATEPART,DATENAME,DATEDIFF,DATEADD";
    }

    public ResultSet getTypeInfo() throws SQLException {
        Statement statement = this.connection.createStatement();
        TdsResultSet tdsResultSet = (TdsResultSet)statement.executeQuery("exec sp_datatype_info");
        Columns columns = tdsResultSet.getContext().getColumnInfo();
        columns.setFakeColumnCount(18);
        columns.setName(11, "FIXED_PREC_SCALE");
        columns.setLabel(11, "FIXED_PREC_SCALE");
        return tdsResultSet;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        String[] stringArray = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS"};
        Columns columns = new Columns(6);
        final Context context = new Context(columns, null);
        int n = 0;
        while (n < 6) {
            columns.setNativeType(n + 1, 39);
            columns.setLabel(n + 1, stringArray[n]);
            columns.setName(n + 1, stringArray[n]);
            ++n;
        }
        return new AbstractResultSet(){

            public SQLWarning getWarnings() throws SQLException {
                return null;
            }

            public String getCursorName() throws SQLException {
                return null;
            }

            public boolean isBeforeFirst() throws SQLException {
                return false;
            }

            public boolean isFirst() throws SQLException {
                return false;
            }

            public boolean first() throws SQLException {
                return false;
            }

            public boolean last() throws SQLException {
                return false;
            }

            public boolean absolute(int n) throws SQLException {
                return false;
            }

            public boolean relative(int n) throws SQLException {
                return false;
            }

            public boolean previous() throws SQLException {
                return false;
            }

            public void setFetchDirection(int n) throws SQLException {
            }

            public int getFetchDirection() throws SQLException {
                return 1000;
            }

            public int getFetchSize() throws SQLException {
                return 0;
            }

            public int getType() throws SQLException {
                return 1003;
            }

            public boolean rowUpdated() throws SQLException {
                return false;
            }

            public boolean rowInserted() throws SQLException {
                return false;
            }

            public boolean rowDeleted() throws SQLException {
                return false;
            }

            public void insertRow() throws SQLException {
            }

            public void updateRow() throws SQLException {
            }

            public void deleteRow() throws SQLException {
            }

            public void refreshRow() throws SQLException {
            }

            public void cancelRowUpdates() throws SQLException {
            }

            public void moveToInsertRow() throws SQLException {
            }

            public void moveToCurrentRow() throws SQLException {
            }

            public Statement getStatement() throws SQLException {
                return null;
            }

            public boolean isLast() throws SQLException {
                return false;
            }

            public boolean isAfterLast() throws SQLException {
                return false;
            }

            public void setFetchSize(int n) throws SQLException {
            }

            public void clearWarnings() throws SQLException {
            }

            public void beforeFirst() throws SQLException {
            }

            public int getRow() throws SQLException {
                return 0;
            }

            public void close() throws SQLException {
            }

            public void afterLast() {
            }

            public boolean next() throws SQLException {
                return false;
            }

            public int getConcurrency() {
                return 1003;
            }

            public Context getContext() {
                return context;
            }

            public PacketRowResult currentRow() throws SQLException {
                return null;
            }
        };
    }

    public String getURL() throws SQLException {
        return this.connection.getUrl();
    }

    public String getUserName() throws SQLException {
        String string;
        Statement statement;
        block6: {
            statement = null;
            ResultSet resultSet = null;
            string = "";
            try {
                statement = this.connection.createStatement();
                resultSet = statement.executeQuery("select system_user");
                if (!resultSet.next()) {
                    throw new SQLException("Couldn't determine user name");
                }
                string = resultSet.getString(1);
                Object var5_4 = null;
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        return string;
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        String string4 = "exec sp_special_columns ?, ?, ?, ?, ?, ?";
        if (string != null) {
            string4 = "exec " + string + "..sp_special_columns ?, ?, ?, ?, ?, ?";
        }
        CallableStatement callableStatement = this.connection.prepareCall(string4);
        callableStatement.setString(1, string3);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string);
        callableStatement.setString(4, "V");
        callableStatement.setString(5, "C");
        callableStatement.setString(6, "O");
        TdsResultSet tdsResultSet = (TdsResultSet)callableStatement.executeQuery();
        Columns columns = tdsResultSet.getContext().getColumnInfo();
        columns.setName(5, "COLUMN_SIZE");
        columns.setLabel(5, "COLUMN_SIZE");
        columns.setName(6, "BUFFER_LENGTH");
        columns.setLabel(6, "BUFFER_LENGTH");
        columns.setName(7, "DECIMAL_DIGITS");
        columns.setLabel(7, "DECIMAL_DIGITS");
        return tdsResultSet;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive == false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive == false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return true;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        if (n == n2) {
            return true;
        }
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return n2 != -1 && n2 != -4;
            }
            case -3: 
            case -2: {
                return n2 != 6 && n2 != 7 && n2 != 8 && n2 != -4;
            }
            case -4: {
                return n2 == -2 || n2 == -3;
            }
            case -1: {
                return n2 == 1 || n2 == 12;
            }
            case 0: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.tds.getServerType() == 1;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.tds.getServerType() != 1;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return true;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return true;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return n2 == 1007;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return n == 1005;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return n == 1005;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return n == 1005;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    private void setCaseSensitiveFlag() throws SQLException {
        if (this.caseSensitive == null) {
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery("sp_server_info 16");
            resultSet.next();
            this.caseSensitive = resultSet.getString(3).equalsIgnoreCase("MIXED") ? Boolean.FALSE : Boolean.TRUE;
            statement.close();
        }
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getDatabaseMajorVersion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getJDBCMajorVersion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getJDBCMinorVersion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getSQLStateType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsNamedParameters() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSavepoints() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsStatementPooling() throws SQLException {
        throw new UnsupportedOperationException();
    }
}

